/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.board;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.FileFormatOption;
import znaishaded.net.sourceforge.plantuml.UmlDiagram;
import znaishaded.net.sourceforge.plantuml.board.Activity;
import znaishaded.net.sourceforge.plantuml.board.PostIt;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.core.DiagramDescription;
import znaishaded.net.sourceforge.plantuml.core.ImageData;
import znaishaded.net.sourceforge.plantuml.core.UmlSource;
import znaishaded.net.sourceforge.plantuml.klimt.UStroke;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColors;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.ULine;
import znaishaded.net.sourceforge.plantuml.skin.UmlDiagramType;

public class BoardDiagram
extends UmlDiagram {
    private final List<Activity> activities = new ArrayList<Activity>();

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("Board");
    }

    public BoardDiagram(UmlSource source) {
        super(source, UmlDiagramType.BOARD, null);
    }

    @Override
    protected ImageData exportDiagramInternal(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        return this.createImageBuilder(fileFormatOption).drawable(this.getTextBlock()).write(os);
    }

    @Override
    protected TextBlock getTextBlock() {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                BoardDiagram.this.drawMe(ug);
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                double width = 200.0;
                double height = 200.0;
                return new XDimension2D(200.0, 200.0);
            }
        };
    }

    private void drawMe(UGraphic ug) {
        UGraphic mug = ug;
        for (Activity activity : this.activities) {
            activity.drawMe(mug);
            mug = mug.apply(UTranslate.dx(activity.getFullWidth()));
        }
        ULine line = ULine.hline(this.getFullWidth());
        for (int i = 0; i < this.getMaxStage(); ++i) {
            double dy = (double)(i + 1) * PostIt.getHeight() - 10.0;
            ug.apply(HColors.BLACK).apply(new UStroke(5.0, 5.0, 0.5)).apply(UTranslate.dy(dy)).draw(line);
        }
    }

    private double getFullWidth() {
        double width = 0.0;
        for (Activity activity : this.activities) {
            width += activity.getFullWidth();
        }
        return width;
    }

    private int getMaxStage() {
        int max = 0;
        for (Activity activity : this.activities) {
            max = Math.max(max, activity.getMaxStage());
        }
        return max;
    }

    private Activity getLastActivity() {
        return this.activities.get(this.activities.size() - 1);
    }

    public CommandExecutionResult addLine(String plus, String label) {
        if (plus.length() == 0) {
            Activity activity = new Activity(this, label, this.getSkinParam());
            this.activities.add(activity);
            return CommandExecutionResult.ok();
        }
        this.getLastActivity().addRelease(plus.length(), label);
        return CommandExecutionResult.ok();
    }
}

