/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.command;

import znaishaded.net.sourceforge.plantuml.TitledDiagram;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.CommandMultilines2;
import znaishaded.net.sourceforge.plantuml.command.MultilinesStrategy;
import znaishaded.net.sourceforge.plantuml.command.Trim;
import znaishaded.net.sourceforge.plantuml.emoji.SvgNanoParser;
import znaishaded.net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import znaishaded.net.sourceforge.plantuml.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.text.StringLocated;
import znaishaded.net.sourceforge.plantuml.utils.BlocLines;

public class CommandSpriteSvgMultiline
extends CommandMultilines2<TitledDiagram> {
    public static final CommandSpriteSvgMultiline ME = new CommandSpriteSvgMultiline();

    private CommandSpriteSvgMultiline() {
        super(CommandSpriteSvgMultiline.getRegexConcat(), MultilinesStrategy.KEEP_STARTING_QUOTE, Trim.BOTH);
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandSpriteSvgMultiline.class.getName(), RegexLeaf.start(), new RegexLeaf("sprite"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("\\$?"), new RegexLeaf("NAME", "([-%pLN_]+)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("SVGSTART", "(\\<svg\\b.*)"), RegexLeaf.end());
    }

    @Override
    public String getPatternEnd() {
        return "(.*\\</svg\\>)$";
    }

    @Override
    protected CommandExecutionResult executeNow(TitledDiagram system, BlocLines lines) throws NoSuchColorException {
        RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
        String svgStart = line0.get("SVGSTART", 0);
        lines = lines.subExtract(1, 0);
        StringBuilder svg = new StringBuilder(svgStart);
        for (StringLocated sl : lines) {
            svg.append(sl.getString());
        }
        SvgNanoParser nanoParser = new SvgNanoParser(svg.toString(), true);
        system.addSprite(line0.get("NAME", 0), nanoParser);
        return CommandExecutionResult.ok();
    }
}

