/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.command.note.sequence;

import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.command.Command;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.CommandMultilines2;
import znaishaded.net.sourceforge.plantuml.command.MultilinesStrategy;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.command.Trim;
import znaishaded.net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import znaishaded.net.sourceforge.plantuml.klimt.color.ColorParser;
import znaishaded.net.sourceforge.plantuml.klimt.color.ColorType;
import znaishaded.net.sourceforge.plantuml.klimt.color.Colors;
import znaishaded.net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Note;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NotePosition;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NoteStyle;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Participant;
import znaishaded.net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import znaishaded.net.sourceforge.plantuml.skin.ColorParam;
import znaishaded.net.sourceforge.plantuml.stereo.Stereotype;
import znaishaded.net.sourceforge.plantuml.url.Url;
import znaishaded.net.sourceforge.plantuml.url.UrlBuilder;
import znaishaded.net.sourceforge.plantuml.url.UrlMode;
import znaishaded.net.sourceforge.plantuml.utils.BlocLines;
import znaishaded.net.sourceforge.plantuml.utils.LineLocation;

public final class FactorySequenceNoteCommand
implements SingleMultiFactoryCommand<SequenceDiagram> {
    private IRegex getRegexConcatMultiLine() {
        return RegexConcat.build(FactorySequenceNoteCommand.class.getName() + "multi", RegexLeaf.start(), new RegexLeaf("PARALLEL", "(&[%s]*)?"), new RegexLeaf("VMERGE", "(/)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STYLE", "(note|hnote|rnote)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREO1", "(\\<\\<.*\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("POSITION", "(right|left|over)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("PARTICIPANT", "(?:of[%s]+)?([%pLN_.@]+|[%g][^%g]+[%g])"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREO2", "(\\<\\<.*\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), FactorySequenceNoteCommand.color().getRegex(), RegexLeaf.spaceZeroOrMore(), UrlBuilder.OPTIONAL, RegexLeaf.end());
    }

    private IRegex getRegexConcatSingleLine() {
        return RegexConcat.build(FactorySequenceNoteCommand.class.getName() + "single", RegexLeaf.start(), new RegexLeaf("PARALLEL", "(&[%s]*)?"), new RegexLeaf("VMERGE", "(/)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STYLE", "(note|hnote|rnote)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREO1", "(\\<\\<.*\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("POSITION", "(right|left|over)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("PARTICIPANT", "(?:of[%s])?([%pLN_.@]+|[%g][^%g]+[%g])"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREO2", "(\\<\\<.*\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), FactorySequenceNoteCommand.color().getRegex(), RegexLeaf.spaceZeroOrMore(), UrlBuilder.OPTIONAL, RegexLeaf.spaceZeroOrMore(), new RegexLeaf(":"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("NOTE", "(.*)"), RegexLeaf.end());
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    public Command<SequenceDiagram> createMultiLine(boolean withBracket) {
        return new CommandMultilines2<SequenceDiagram>(this.getRegexConcatMultiLine(), MultilinesStrategy.KEEP_STARTING_QUOTE, Trim.BOTH){

            @Override
            public String getPatternEnd() {
                return "^end[%s]?(note|hnote|rnote)$";
            }

            @Override
            protected CommandExecutionResult executeNow(SequenceDiagram system, BlocLines lines) throws NoSuchColorException {
                RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
                lines = lines.subExtract(1, 1);
                lines = lines.removeEmptyColumns();
                return FactorySequenceNoteCommand.this.executeInternal(system, line0, lines);
            }
        };
    }

    @Override
    public Command<SequenceDiagram> createSingleLine() {
        return new SingleLineCommand2<SequenceDiagram>(this.getRegexConcatSingleLine()){

            @Override
            protected CommandExecutionResult executeArg(SequenceDiagram diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
                return FactorySequenceNoteCommand.this.executeInternal(diagram, arg, BlocLines.getWithNewlines(arg.get("NOTE", 0)));
            }
        };
    }

    private CommandExecutionResult executeInternal(SequenceDiagram diagram, RegexResult arg, BlocLines strings) throws NoSuchColorException {
        Participant p = diagram.getOrCreateParticipant(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("PARTICIPANT", 0)));
        NotePosition position = NotePosition.valueOf(StringUtils.goUpperCase(arg.get("POSITION", 0)));
        if (strings.size() > 0) {
            boolean tryMerge = arg.get("VMERGE", 0) != null;
            boolean parallel = arg.get("PARALLEL", 0) != null;
            Display display = diagram.manageVariable(strings.toDisplay());
            Note note = new Note(p, position, display, diagram.getSkinParam().getCurrentStyleBuilder());
            Colors colors = FactorySequenceNoteCommand.color().getColor(arg, diagram.getSkinParam().getIHtmlColorSet());
            String stereotypeString = arg.getLazzy("STEREO", 0);
            if (stereotypeString != null) {
                Stereotype stereotype = Stereotype.build(stereotypeString);
                colors = colors.applyStereotypeForNote(stereotype, diagram.getSkinParam(), ColorParam.noteBackground, ColorParam.noteBorder);
                note.setStereotype(stereotype);
            }
            note.setColors(colors);
            note.setNoteStyle(NoteStyle.getNoteStyle(arg.get("STYLE", 0)));
            if (arg.get("URL", 0) != null) {
                UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlMode.STRICT);
                Url urlLink = urlBuilder.getUrl(arg.get("URL", 0));
                note.setUrl(urlLink);
            }
            if (parallel) {
                note.goParallel();
            }
            diagram.addNote(note, tryMerge);
        }
        return CommandExecutionResult.ok();
    }
}

