/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.decoration.symbol;

import java.util.HashMap;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.decoration.symbol.USymbol;
import znaishaded.net.sourceforge.plantuml.decoration.symbol.USymbolActor;
import znaishaded.net.sourceforge.plantuml.decoration.symbol.USymbolActorBusiness;
import znaishaded.net.sourceforge.plantuml.decoration.symbol.USymbolArtifact;
import znaishaded.net.sourceforge.plantuml.decoration.symbol.USymbolBoundary;
import znaishaded.net.sourceforge.plantuml.decoration.symbol.USymbolCard;
import znaishaded.net.sourceforge.plantuml.decoration.symbol.USymbolCloud;
import znaishaded.net.sourceforge.plantuml.decoration.symbol.USymbolCollections;
import znaishaded.net.sourceforge.plantuml.decoration.symbol.USymbolComponent1;
import znaishaded.net.sourceforge.plantuml.decoration.symbol.USymbolComponent2;
import znaishaded.net.sourceforge.plantuml.decoration.symbol.USymbolControl;
import znaishaded.net.sourceforge.plantuml.decoration.symbol.USymbolDatabase;
import znaishaded.net.sourceforge.plantuml.decoration.symbol.USymbolEntityDomain;
import znaishaded.net.sourceforge.plantuml.decoration.symbol.USymbolFile;
import znaishaded.net.sourceforge.plantuml.decoration.symbol.USymbolFolder;
import znaishaded.net.sourceforge.plantuml.decoration.symbol.USymbolFrame;
import znaishaded.net.sourceforge.plantuml.decoration.symbol.USymbolHexagon;
import znaishaded.net.sourceforge.plantuml.decoration.symbol.USymbolInterface;
import znaishaded.net.sourceforge.plantuml.decoration.symbol.USymbolLabel;
import znaishaded.net.sourceforge.plantuml.decoration.symbol.USymbolNode;
import znaishaded.net.sourceforge.plantuml.decoration.symbol.USymbolPerson;
import znaishaded.net.sourceforge.plantuml.decoration.symbol.USymbolQueue;
import znaishaded.net.sourceforge.plantuml.decoration.symbol.USymbolRectangle;
import znaishaded.net.sourceforge.plantuml.decoration.symbol.USymbolStack;
import znaishaded.net.sourceforge.plantuml.decoration.symbol.USymbolStorage;
import znaishaded.net.sourceforge.plantuml.skin.ActorStyle;
import znaishaded.net.sourceforge.plantuml.skin.ComponentStyle;
import znaishaded.net.sourceforge.plantuml.style.ISkinParam;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.svek.PackageStyle;

public abstract class USymbols {
    private static final Map<String, USymbol> all = new HashMap<String, USymbol>();
    public static final USymbol STORAGE = USymbols.record("STORAGE", new USymbolStorage());
    public static final USymbol DATABASE = USymbols.record("DATABASE", new USymbolDatabase());
    public static final USymbol CLOUD = USymbols.record("CLOUD", new USymbolCloud());
    public static final USymbol CARD = USymbols.record("CARD", new USymbolCard());
    public static final USymbol FRAME = USymbols.record("FRAME", new USymbolFrame(SName.frame));
    public static final USymbol PARTITION = USymbols.record("PARTITION", new USymbolFrame(SName.partition));
    public static final USymbol GROUP = USymbols.record("GROUP", new USymbolFrame(SName.group));
    public static final USymbol NODE = USymbols.record("NODE", new USymbolNode());
    public static final USymbol ARTIFACT = USymbols.record("ARTIFACT", new USymbolArtifact());
    public static final USymbol PACKAGE = USymbols.record("PACKAGE", new USymbolFolder(SName.package_, true));
    public static final USymbol FOLDER = USymbols.record("FOLDER", new USymbolFolder(SName.folder, false));
    public static final USymbol FILE = USymbols.record("FILE", new USymbolFile());
    public static final USymbol RECTANGLE = USymbols.record("RECTANGLE", new USymbolRectangle(SName.rectangle));
    public static final USymbol HEXAGON = USymbols.record("HEXAGON", new USymbolHexagon());
    public static final USymbol PERSON = USymbols.record("PERSON", new USymbolPerson());
    public static final USymbol LABEL = USymbols.record("LABEL", new USymbolLabel());
    public static final USymbol ARCHIMATE = USymbols.record("ARCHIMATE", new USymbolRectangle(SName.archimate));
    public static final USymbol COLLECTIONS = USymbols.record("COLLECTIONS", new USymbolCollections());
    public static final USymbol AGENT = USymbols.record("AGENT", new USymbolRectangle(SName.agent));
    public static final USymbol ACTOR_STICKMAN = USymbols.record("ACTOR_STICKMAN", new USymbolActor(ActorStyle.STICKMAN));
    public static final USymbol ACTOR_STICKMAN_BUSINESS = USymbols.record("ACTOR_STICKMAN_BUSINESS", new USymbolActorBusiness());
    public static final USymbol ACTOR_AWESOME = USymbols.record("ACTOR_AWESOME", new USymbolActor(ActorStyle.AWESOME));
    public static final USymbol ACTOR_HOLLOW = USymbols.record("ACTOR_HOLLOW", new USymbolActor(ActorStyle.HOLLOW));
    public static final USymbol USECASE = null;
    public static final USymbol COMPONENT1 = USymbols.record("COMPONENT1", new USymbolComponent1());
    public static final USymbol COMPONENT2 = USymbols.record("COMPONENT2", new USymbolComponent2());
    public static final USymbol COMPONENT_RECTANGLE = USymbols.record("COMPONENT_RECTANGLE", new USymbolRectangle(SName.component));
    public static final USymbol BOUNDARY = USymbols.record("BOUNDARY", new USymbolBoundary());
    public static final USymbol ENTITY_DOMAIN = USymbols.record("ENTITY_DOMAIN", new USymbolEntityDomain());
    public static final USymbol CONTROL = USymbols.record("CONTROL", new USymbolControl());
    public static final USymbol INTERFACE = USymbols.record("INTERFACE", new USymbolInterface());
    public static final USymbol QUEUE = USymbols.record("QUEUE", new USymbolQueue());
    public static final USymbol STACK = USymbols.record("STACK", new USymbolStack());

    private USymbols() {
    }

    private static USymbol record(String code, USymbol symbol) {
        all.put(StringUtils.goUpperCase(code), symbol);
        return symbol;
    }

    public static USymbol fromString(String s2, ActorStyle actorStyle, ComponentStyle componentStyle, PackageStyle packageStyle) {
        if (s2 == null) {
            return null;
        }
        if (s2.equalsIgnoreCase("package")) {
            return packageStyle.toUSymbol();
        }
        if (s2.equalsIgnoreCase("actor")) {
            return actorStyle.toUSymbol();
        }
        if (s2.equalsIgnoreCase("component")) {
            return componentStyle.toUSymbol();
        }
        if (s2.equalsIgnoreCase("entity")) {
            return ENTITY_DOMAIN;
        }
        if (s2.equalsIgnoreCase("circle")) {
            return INTERFACE;
        }
        USymbol result = all.get(StringUtils.goUpperCase(s2.replaceAll("\\W", "")));
        return result;
    }

    public static USymbol fromString(String symbol, ISkinParam skinParam) {
        USymbol usymbol = null;
        if (symbol.equalsIgnoreCase("artifact")) {
            usymbol = ARTIFACT;
        } else if (symbol.equalsIgnoreCase("folder")) {
            usymbol = FOLDER;
        } else if (symbol.equalsIgnoreCase("file")) {
            usymbol = FILE;
        } else if (symbol.equalsIgnoreCase("package")) {
            usymbol = PACKAGE;
        } else if (symbol.equalsIgnoreCase("rectangle")) {
            usymbol = RECTANGLE;
        } else if (symbol.equalsIgnoreCase("person")) {
            usymbol = PERSON;
        } else if (symbol.equalsIgnoreCase("hexagon")) {
            usymbol = HEXAGON;
        } else if (symbol.equalsIgnoreCase("label")) {
            usymbol = LABEL;
        } else if (symbol.equalsIgnoreCase("collections")) {
            usymbol = COLLECTIONS;
        } else if (symbol.equalsIgnoreCase("node")) {
            usymbol = NODE;
        } else if (symbol.equalsIgnoreCase("frame")) {
            usymbol = FRAME;
        } else if (symbol.equalsIgnoreCase("cloud")) {
            usymbol = CLOUD;
        } else if (symbol.equalsIgnoreCase("database")) {
            usymbol = DATABASE;
        } else if (symbol.equalsIgnoreCase("queue")) {
            usymbol = QUEUE;
        } else if (symbol.equalsIgnoreCase("stack")) {
            usymbol = STACK;
        } else if (symbol.equalsIgnoreCase("storage")) {
            usymbol = STORAGE;
        } else if (symbol.equalsIgnoreCase("agent")) {
            usymbol = AGENT;
        } else if (symbol.equalsIgnoreCase("actor/")) {
            usymbol = ACTOR_STICKMAN_BUSINESS;
        } else if (symbol.equalsIgnoreCase("actor")) {
            usymbol = skinParam.actorStyle().toUSymbol();
        } else if (symbol.equalsIgnoreCase("component")) {
            usymbol = skinParam.componentStyle().toUSymbol();
        } else if (symbol.equalsIgnoreCase("boundary")) {
            usymbol = BOUNDARY;
        } else if (symbol.equalsIgnoreCase("control")) {
            usymbol = CONTROL;
        } else if (symbol.equalsIgnoreCase("entity")) {
            usymbol = ENTITY_DOMAIN;
        } else if (symbol.equalsIgnoreCase("card")) {
            usymbol = CARD;
        } else if (symbol.equalsIgnoreCase("interface")) {
            usymbol = INTERFACE;
        } else if (symbol.equalsIgnoreCase("()")) {
            usymbol = INTERFACE;
        }
        return usymbol;
    }
}

