/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.descdiagram;

import znaishaded.net.sourceforge.plantuml.abel.Entity;
import znaishaded.net.sourceforge.plantuml.descdiagram.BoxedCharacter;
import znaishaded.net.sourceforge.plantuml.klimt.UStroke;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.color.ColorType;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontParam;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.font.UFont;
import znaishaded.net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.geom.PlacementStrategyY1Y2;
import znaishaded.net.sourceforge.plantuml.klimt.geom.ULayoutGroup;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.klimt.shape.URectangle;
import znaishaded.net.sourceforge.plantuml.skin.ColorParam;
import znaishaded.net.sourceforge.plantuml.skin.LineParam;
import znaishaded.net.sourceforge.plantuml.skin.SkinParamUtils;
import znaishaded.net.sourceforge.plantuml.stereo.Stereotype;
import znaishaded.net.sourceforge.plantuml.style.ISkinParam;
import znaishaded.net.sourceforge.plantuml.svek.AbstractEntityImage;
import znaishaded.net.sourceforge.plantuml.svek.ShapeType;
import znaishaded.net.sourceforge.plantuml.text.Guillemet;
import znaishaded.net.sourceforge.plantuml.url.Url;

public class EntityImageDomain
extends AbstractEntityImage {
    private final TextBlock name;
    private final TextBlock tag;
    private final TextBlock stereo;
    private final Url url;

    public EntityImageDomain(Entity entity, ISkinParam skinParam, char typeLetter) {
        super(entity, skinParam);
        Stereotype stereotype = entity.getStereotype();
        FontConfiguration fc = FontConfiguration.create(this.getSkinParam(), FontParam.DESIGNED_DOMAIN, stereotype);
        this.name = TextBlockUtils.withMargin(entity.getDisplay().create(fc, HorizontalAlignment.CENTER, skinParam), 2.0, 2.0);
        this.stereo = stereotype == null || stereotype.getLabel(Guillemet.DOUBLE_COMPARATOR) == null ? null : Display.create(stereotype.getLabels(skinParam.guillemet())).create(FontConfiguration.create(this.getSkinParam(), FontParam.DESIGNED_DOMAIN_STEREOTYPE, stereotype), HorizontalAlignment.CENTER, skinParam);
        this.tag = new BoxedCharacter(typeLetter, 8.0, UFont.byDefault(8), stereotype.getHtmlColor(), null, fc.getColor());
        this.url = entity.getUrl99();
    }

    private UStroke getStroke() {
        UStroke stroke = this.getSkinParam().getThickness(LineParam.domainBorder, this.getStereo());
        if (stroke == null) {
            stroke = UStroke.withThickness(1.5);
        }
        return stroke;
    }

    private XDimension2D getTitleDimension(StringBounder stringBounder) {
        return this.getNameAndSteretypeDimension(stringBounder);
    }

    private XDimension2D getNameAndSteretypeDimension(StringBounder stringBounder) {
        XDimension2D nameDim = this.name.calculateDimension(stringBounder);
        XDimension2D stereoDim = this.stereo == null ? new XDimension2D(0.0, 0.0) : this.stereo.calculateDimension(stringBounder);
        XDimension2D nameAndStereo = new XDimension2D(Math.max(nameDim.getWidth(), stereoDim.getWidth()), nameDim.getHeight() + stereoDim.getHeight());
        return nameAndStereo;
    }

    public double getStartingX(StringBounder stringBounder, double y) {
        return 0.0;
    }

    public double getEndingX(StringBounder stringBounder, double y) {
        return this.calculateDimension(stringBounder).getWidth();
    }

    @Override
    public final void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D dimTotal = this.calculateDimension(stringBounder);
        XDimension2D dimTitle = this.getTitleDimension(stringBounder);
        XDimension2D dimTag = this.getTagDimension(stringBounder);
        double widthTotal = dimTotal.getWidth();
        double heightTotal = dimTotal.getHeight();
        URectangle rect = URectangle.build(widthTotal, heightTotal);
        ug = ug.apply(SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.domainBorder));
        HColor backcolor = this.getEntity().getColors().getColor(ColorType.BACK);
        if (backcolor == null) {
            backcolor = SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.domainBackground);
        }
        ug = ug.apply(backcolor.bg());
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        UStroke stroke = this.getStroke();
        ug.apply(stroke).draw(rect);
        ULayoutGroup header = new ULayoutGroup(new PlacementStrategyY1Y2(ug.getStringBounder()));
        header.add(this.name);
        header.drawU(ug, dimTotal.getWidth(), dimTitle.getHeight());
        ULayoutGroup footer = new ULayoutGroup(new PlacementStrategyY1Y2(ug.getStringBounder()));
        footer.add(this.tag);
        footer.drawU(ug.apply(new UTranslate(dimTotal.getWidth() - dimTag.getWidth(), dimTitle.getHeight())), dimTag.getWidth(), dimTag.getHeight());
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    private XDimension2D getTagDimension(StringBounder stringBounder) {
        XDimension2D tagDim = this.tag == null ? new XDimension2D(0.0, 0.0) : this.tag.calculateDimension(stringBounder);
        return tagDim;
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        XDimension2D dimTitle = this.getTitleDimension(stringBounder);
        double width = dimTitle.getWidth();
        double height = dimTitle.getHeight();
        XDimension2D dimTag = this.getTagDimension(stringBounder);
        return new XDimension2D(width, height + dimTag.getHeight());
    }
}

