/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.hcl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.hcl.HclTerm;
import znaishaded.net.sourceforge.plantuml.hcl.SymbolType;
import znaishaded.net.sourceforge.plantuml.json.Json;
import znaishaded.net.sourceforge.plantuml.json.JsonArray;
import znaishaded.net.sourceforge.plantuml.json.JsonObject;
import znaishaded.net.sourceforge.plantuml.json.JsonString;
import znaishaded.net.sourceforge.plantuml.json.JsonValue;

public class HclParser {
    private final List<HclTerm> terms = new ArrayList<HclTerm>();

    public HclParser(Iterable<Character> source) {
        this.parse(source.iterator());
    }

    public JsonObject parseMe() {
        LinkedHashMap<String, JsonObject> map = new LinkedHashMap<String, JsonObject>();
        Iterator<HclTerm> it = this.terms.iterator();
        while (it.hasNext()) {
            map.putAll(this.getModuleOrSomething(it));
        }
        if (map.size() == 1) {
            return (JsonObject)map.values().iterator().next();
        }
        JsonObject result = new JsonObject();
        for (Map.Entry ent : map.entrySet()) {
            result.add((String)ent.getKey(), (JsonValue)ent.getValue());
        }
        return result;
    }

    private Map<String, JsonObject> getModuleOrSomething(Iterator<HclTerm> it) {
        HclTerm current;
        StringBuilder name = new StringBuilder();
        while (true) {
            if ((current = it.next()).is(SymbolType.STRING_QUOTED)) {
                name.append("\"" + current.getData() + "\" ");
                continue;
            }
            if (!current.is(SymbolType.STRING_SIMPLE)) break;
            name.append(current.getData() + " ");
        }
        if (current.is(SymbolType.CURLY_BRACKET_OPEN)) {
            return Collections.singletonMap(name.toString().trim(), this.getBracketData(it));
        }
        throw new IllegalStateException(current.toString());
    }

    private JsonValue getFunctionData(String functionName, Iterator<HclTerm> it) {
        JsonArray args = new JsonArray();
        if (!it.next().is(SymbolType.PARENTHESIS_OPEN)) {
            throw new IllegalStateException();
        }
        while (true) {
            Object value;
            if ((value = this.getValue(it)) instanceof HclTerm && ((HclTerm)value).is(SymbolType.PARENTHESIS_CLOSE)) {
                if (args.size() == 0) {
                    return Json.value(functionName + "()");
                }
                JsonObject result = new JsonObject();
                result.add(functionName + "()", args);
                return result;
            }
            if (value instanceof HclTerm && ((HclTerm)value).is(SymbolType.COMMA)) continue;
            if (value instanceof String) {
                args.add((String)value);
                continue;
            }
            if (value instanceof JsonArray) {
                args.add((JsonArray)value);
                continue;
            }
            if (value instanceof JsonObject) {
                args.add((JsonObject)value);
                continue;
            }
            if (!(value instanceof JsonString)) break;
            args.add((JsonString)value);
        }
        throw new IllegalStateException();
    }

    private JsonObject getBracketData(Iterator<HclTerm> it) {
        HclTerm current;
        block6: {
            JsonObject result = new JsonObject();
            while (true) {
                if ((current = it.next()).is(SymbolType.CURLY_BRACKET_CLOSE)) {
                    return result;
                }
                if (!current.is(SymbolType.STRING_SIMPLE) && !current.is(SymbolType.STRING_QUOTED)) break block6;
                String fieldName = current.getData();
                HclTerm next = it.next();
                if (!next.is(SymbolType.EQUALS, SymbolType.TWO_POINTS)) {
                    throw new IllegalStateException(current.toString());
                }
                Object value = this.getValue(it);
                if (value instanceof String) {
                    result.add(fieldName, (String)value);
                    continue;
                }
                if (value instanceof JsonArray) {
                    result.add(fieldName, (JsonArray)value);
                    continue;
                }
                if (value instanceof JsonObject) {
                    result.add(fieldName, (JsonObject)value);
                    continue;
                }
                if (!(value instanceof JsonString)) break;
                result.add(fieldName, (JsonString)value);
            }
            throw new IllegalStateException();
        }
        throw new IllegalStateException(current.toString());
    }

    private Object getValue(Iterator<HclTerm> it) {
        HclTerm current = it.next();
        if (current.is(SymbolType.COMMA, SymbolType.PARENTHESIS_CLOSE)) {
            return current;
        }
        if (current.is(SymbolType.STRING_QUOTED)) {
            return current.getData();
        }
        if (current.is(SymbolType.STRING_SIMPLE)) {
            return current.getData();
        }
        if (current.is(SymbolType.SQUARE_BRACKET_OPEN)) {
            return this.getArray(it);
        }
        if (current.is(SymbolType.CURLY_BRACKET_OPEN)) {
            return this.getBracketData(it);
        }
        if (current.is(SymbolType.FUNCTION_NAME)) {
            return this.getFunctionData(current.getData(), it);
        }
        throw new IllegalStateException(current.toString());
    }

    private Object getArray(Iterator<HclTerm> it) {
        JsonArray result = new JsonArray();
        while (true) {
            HclTerm current;
            if ((current = it.next()).is(SymbolType.CURLY_BRACKET_OPEN)) {
                result.add(this.getBracketData(it));
            }
            if (current.is(SymbolType.SQUARE_BRACKET_CLOSE)) {
                return result;
            }
            if (current.is(SymbolType.COMMA) || !current.is(SymbolType.STRING_QUOTED)) continue;
            result.add(current.getData());
        }
    }

    public String toString() {
        return this.terms.toString();
    }

    private void parse(Iterator<Character> it) {
        StringBuilder pendingString = new StringBuilder();
        while (it.hasNext()) {
            char c = it.next().charValue();
            SymbolType type = this.getType(c);
            if (type == SymbolType.PARENTHESIS_OPEN) {
                if (pendingString.length() == 0) {
                    throw new IllegalArgumentException();
                }
                this.terms.add(new HclTerm(SymbolType.FUNCTION_NAME, pendingString.toString()));
                pendingString.setLength(0);
            } else if (type != null && pendingString.length() > 0) {
                this.terms.add(new HclTerm(SymbolType.STRING_SIMPLE, pendingString.toString()));
                pendingString.setLength(0);
            }
            if (type == SymbolType.SPACE) continue;
            if (type != null) {
                this.terms.add(new HclTerm(type));
                continue;
            }
            if (c == '\"') {
                String s2 = this.eatUntilDoubleQuote(it);
                this.terms.add(new HclTerm(SymbolType.STRING_QUOTED, s2));
                continue;
            }
            pendingString.append(c);
        }
    }

    private String eatUntilDoubleQuote(Iterator<Character> it) {
        StringBuilder sb = new StringBuilder();
        while (it.hasNext()) {
            char c = it.next().charValue();
            if (c == '\\') {
                sb.append(it.next());
                continue;
            }
            if (c == '\"') {
                return sb.toString();
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private SymbolType getType(char c) {
        if (Character.isSpaceChar(c)) {
            return SymbolType.SPACE;
        }
        if (c == '{') {
            return SymbolType.CURLY_BRACKET_OPEN;
        }
        if (c == '}') {
            return SymbolType.CURLY_BRACKET_CLOSE;
        }
        if (c == '[') {
            return SymbolType.SQUARE_BRACKET_OPEN;
        }
        if (c == ']') {
            return SymbolType.SQUARE_BRACKET_CLOSE;
        }
        if (c == '(') {
            return SymbolType.PARENTHESIS_OPEN;
        }
        if (c == ')') {
            return SymbolType.PARENTHESIS_CLOSE;
        }
        if (c == '=') {
            return SymbolType.EQUALS;
        }
        if (c == ',') {
            return SymbolType.COMMA;
        }
        if (c == ':') {
            return SymbolType.TWO_POINTS;
        }
        return null;
    }
}

