/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.creole.command;

import znaishaded.net.sourceforge.plantuml.klimt.creole.command.Command;
import znaishaded.net.sourceforge.plantuml.klimt.creole.legacy.StripeSimple;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.regex.Pattern2;

public class CommandCreoleSizeChange
implements Command {
    private final Pattern2 mypattern;
    private static final Pattern2 pattern = MyPattern.cmpile("^(\\<size[\\s:]+(\\d+)[%s]*\\>(.*?)\\</size\\>)");
    private static final Pattern2 patternEol = MyPattern.cmpile("^(\\<size[\\s:]+(\\d+)[%s]*\\>(.*)$)");

    @Override
    public String startingChars() {
        return "<";
    }

    public static Command create() {
        return new CommandCreoleSizeChange(pattern);
    }

    public static Command createEol() {
        return new CommandCreoleSizeChange(patternEol);
    }

    private CommandCreoleSizeChange(Pattern2 p) {
        this.mypattern = p;
    }

    @Override
    public int matchingSize(String line) {
        Matcher2 m3 = this.mypattern.matcher(line);
        if (!m3.find()) {
            return 0;
        }
        return m3.group(2).length();
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) {
        Matcher2 m3 = this.mypattern.matcher(line);
        if (!m3.find()) {
            throw new IllegalStateException();
        }
        int size = Integer.parseInt(m3.group(2));
        FontConfiguration fc1 = stripe.getActualFontConfiguration();
        FontConfiguration fc2 = fc1.changeSize(size);
        stripe.setActualFontConfiguration(fc2);
        stripe.analyzeAndAdd(m3.group(3));
        stripe.setActualFontConfiguration(fc1);
        return line.substring(m3.group(1).length());
    }
}

