/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.drawing.g2d;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import znaishaded.net.sourceforge.plantuml.utils.Log;

public class DriverShadowedG2d {
    private final Color color = new Color(170, 170, 170);
    private final Color colorLine = new Color(30, 30, 30);

    private ConvolveOp getConvolveOp(int blurRadius, double dpiFactor) {
        float[] elements = new float[(int)((double)(blurRadius * blurRadius) * dpiFactor)];
        for (int k = 0; k < elements.length; ++k) {
            elements[k] = (float)(1.0 / (double)elements.length);
        }
        Kernel myKernel = new Kernel((int)((double)blurRadius * Math.sqrt(dpiFactor)), (int)((double)blurRadius * Math.sqrt(dpiFactor)), elements);
        return new ConvolveOp(myKernel, 1, null);
    }

    protected void drawShadow(Graphics2D g2d, Shape shape, double deltaShadow, double dpiFactor) {
        if (dpiFactor < 1.0) {
            dpiFactor = 1.0;
        }
        Rectangle2D bounds = shape.getBounds2D();
        double ww = bounds.getMaxX() - bounds.getMinX();
        double hh = bounds.getMaxY() - bounds.getMinY();
        double w = (ww + deltaShadow * 2.0 + 6.0) * dpiFactor;
        double h2 = (hh + deltaShadow * 2.0 + 6.0) * dpiFactor;
        BufferedImage destination = null;
        try {
            destination = new BufferedImage((int)w, (int)h2, 2);
            Graphics2D gg = destination.createGraphics();
            gg.scale(dpiFactor, dpiFactor);
            gg.translate(deltaShadow - bounds.getMinX(), deltaShadow - bounds.getMinY());
            boolean isLine = shape instanceof Line2D.Double;
            if (isLine) {
                gg.setColor(this.colorLine);
                gg.draw(shape);
            } else {
                gg.setColor(this.color);
                gg.fill(shape);
            }
            gg.dispose();
            ConvolveOp simpleBlur = this.getConvolveOp(6, dpiFactor);
            destination = simpleBlur.filter(destination, null);
        }
        catch (OutOfMemoryError error) {
            Log.info("Warning: Cannot draw shadow, image too big.");
        }
        catch (Exception e) {
            Log.info("Warning: Cannot draw shadow: " + e);
        }
        if (destination != null) {
            AffineTransform at = g2d.getTransform();
            g2d.scale(1.0 / dpiFactor, 1.0 / dpiFactor);
            g2d.drawImage((Image)destination, (int)(bounds.getMinX() * dpiFactor), (int)(bounds.getMinY() * dpiFactor), null);
            g2d.setTransform(at);
        }
    }

    protected void drawOnlyLineShadow(Graphics2D g2d, Shape shape, double deltaShadow, double dpiFactor) {
        if (dpiFactor < 1.0) {
            dpiFactor = 1.0;
        }
        Rectangle2D bounds = shape.getBounds2D();
        double ww = bounds.getMaxX() - bounds.getMinX();
        double hh = bounds.getMaxY() - bounds.getMinY();
        double w = (ww + deltaShadow * 2.0 + 6.0) * dpiFactor;
        double h2 = (hh + deltaShadow * 2.0 + 6.0) * dpiFactor;
        BufferedImage destination = null;
        try {
            destination = new BufferedImage((int)w, (int)h2, 2);
            Graphics2D gg = destination.createGraphics();
            gg.scale(dpiFactor, dpiFactor);
            gg.translate(deltaShadow - bounds.getMinX(), deltaShadow - bounds.getMinY());
            gg.draw(shape);
            gg.dispose();
            ConvolveOp simpleBlur = this.getConvolveOp(6, dpiFactor);
            destination = simpleBlur.filter(destination, null);
        }
        catch (OutOfMemoryError error) {
            Log.info("Warning: Cannot draw shadow, image too big.");
        }
        catch (Exception e) {
            Log.info("Warning: Cannot draw shadow: " + e);
        }
        if (destination != null) {
            AffineTransform at = g2d.getTransform();
            g2d.scale(1.0 / dpiFactor, 1.0 / dpiFactor);
            g2d.drawImage((Image)destination, (int)(bounds.getMinX() * dpiFactor), (int)(bounds.getMinY() * dpiFactor), null);
            g2d.setTransform(at);
        }
    }

    protected void drawOnlyLineShadowSpecial(Graphics2D g2d, Shape shape, double deltaShadow, double dpiFactor) {
        if (dpiFactor < 1.0) {
            dpiFactor = 1.0;
        }
        Rectangle2D bounds = shape.getBounds2D();
        double ww = bounds.getMaxX() - bounds.getMinX();
        double hh = bounds.getMaxY() - bounds.getMinY();
        double w = (ww + deltaShadow * 2.0 + 6.0) * dpiFactor;
        double h2 = (hh + deltaShadow * 2.0 + 6.0) * dpiFactor;
        BufferedImage destination = null;
        try {
            destination = new BufferedImage((int)w, (int)h2, 2);
            Graphics2D gg = destination.createGraphics();
            gg.scale(dpiFactor, dpiFactor);
            gg.translate(deltaShadow - bounds.getMinX(), deltaShadow - bounds.getMinY());
            gg.draw(shape);
            gg.dispose();
            ConvolveOp simpleBlur = this.getConvolveOp(6, dpiFactor);
            destination = simpleBlur.filter(destination, null);
        }
        catch (OutOfMemoryError error) {
            Log.info("Warning: Cannot draw shadow, image too big.");
        }
        catch (Exception e) {
            Log.info("Warning: Cannot draw shadow: " + e);
        }
        if (destination != null) {
            AffineTransform at = g2d.getTransform();
            g2d.scale(1.0 / dpiFactor, 1.0 / dpiFactor);
            Shape sav = g2d.getClip();
            Area full = new Area(new Rectangle2D.Double(0.0, 0.0, (bounds.getMaxX() + deltaShadow * 2.0 + 6.0) * dpiFactor, (bounds.getMaxY() + deltaShadow * 2.0 + 6.0) * dpiFactor));
            if (dpiFactor == 1.0) {
                full.subtract(new Area(shape));
            } else {
                full.subtract(new Area(shape).createTransformedArea(AffineTransform.getScaleInstance(dpiFactor, dpiFactor)));
            }
            g2d.setClip(full);
            g2d.drawImage((Image)destination, (int)(bounds.getMinX() * dpiFactor), (int)(bounds.getMinY() * dpiFactor), null);
            g2d.setClip(sav);
            g2d.setTransform(at);
        }
    }
}

