/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.drawing.svg;

import java.io.IOException;
import znaishaded.net.sourceforge.plantuml.klimt.ClipContainer;
import znaishaded.net.sourceforge.plantuml.klimt.UClip;
import znaishaded.net.sourceforge.plantuml.klimt.UParam;
import znaishaded.net.sourceforge.plantuml.klimt.color.ColorMapper;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UDriver;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.svg.SvgGraphics;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UImage;
import znaishaded.net.sourceforge.plantuml.utils.Log;

public class DriverImagePng
implements UDriver<UImage, SvgGraphics> {
    private final ClipContainer clipContainer;

    public DriverImagePng(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UImage image, double x, double y, ColorMapper mapper, UParam param, SvgGraphics svg) {
        UClip clip = this.clipContainer.getClip();
        if (clip != null) {
            if (!clip.isInside(x, y)) {
                return;
            }
            if (!clip.isInside(x + (double)image.getWidth(), y + (double)image.getHeight())) {
                return;
            }
        }
        try {
            svg.svgImage(image.getImage(1.0), x, y);
        }
        catch (IOException e) {
            Log.error("Error in svg for image " + e);
        }
    }
}

