/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.geom;

import znaishaded.net.sourceforge.plantuml.klimt.geom.Positionable;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XCubicCurve2D;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XLine2D;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XPoint2D;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XRectangle2D;

public class BezierUtils {
    public static double getEndingAngle(XCubicCurve2D left) {
        if (left.getCtrlP2().equals(left.getP2())) {
            return BezierUtils.getAngle(left.getP1(), left.getP2());
        }
        return BezierUtils.getAngle(left.getCtrlP2(), left.getP2());
    }

    public static double getStartingAngle(XCubicCurve2D left) {
        if (left.getP1().equals(left.getCtrlP1())) {
            return BezierUtils.getAngle(left.getP1(), left.getP2());
        }
        return BezierUtils.getAngle(left.getP1(), left.getCtrlP1());
    }

    public static double getAngle(XPoint2D p1, XPoint2D p2) {
        if (p1.equals(p2)) {
            throw new IllegalArgumentException();
        }
        return Math.atan2(p2.getY() - p1.getY(), p2.getX() - p1.getX());
    }

    private static boolean isCutting(XCubicCurve2D bez, XRectangle2D shape) {
        boolean contains1 = shape.contains(bez.x1, bez.y1);
        boolean contains2 = shape.contains(bez.x2, bez.y2);
        return contains1 ^ contains2;
    }

    private static void shorten(XCubicCurve2D bez, XRectangle2D shape) {
        boolean contains2;
        boolean contains1 = shape.contains(bez.x1, bez.y1);
        if (contains1 ^ !(contains2 = shape.contains(bez.x2, bez.y2))) {
            throw new IllegalArgumentException();
        }
        if (!contains1) {
            bez.setCurve(bez.x2, bez.y2, bez.ctrlx2, bez.ctrly2, bez.ctrlx1, bez.ctrly1, bez.x1, bez.y1);
        }
        assert (shape.contains(bez.x1, bez.y1) && !shape.contains(bez.x2, bez.y2));
        XCubicCurve2D left = XCubicCurve2D.none();
        XCubicCurve2D right = XCubicCurve2D.none();
        BezierUtils.subdivide(bez, left, right, 0.5);
        if (BezierUtils.isCutting(left, shape) ^ !BezierUtils.isCutting(right, shape)) {
            throw new IllegalArgumentException();
        }
        if (BezierUtils.isCutting(left, shape)) {
            bez.setCurve(left);
        } else {
            bez.setCurve(right);
        }
    }

    private static void subdivide(XCubicCurve2D src, XCubicCurve2D left, XCubicCurve2D right, double coef) {
        double coef1 = coef;
        double coef2 = 1.0 - coef;
        double centerxA = src.getCtrlX1() * coef1 + src.getCtrlX2() * coef2;
        double centeryA = src.getCtrlY1() * coef1 + src.getCtrlY2() * coef2;
        double x1 = src.getX1();
        double y1 = src.getY1();
        double x2 = src.getX2();
        double y2 = src.getY2();
        double ctrlx1 = x1 * coef1 + src.getCtrlX1() * coef1;
        double ctrly1 = y1 * coef1 + src.getCtrlY1() * coef1;
        double ctrlx2 = x2 * coef1 + src.getCtrlX2() * coef1;
        double ctrly2 = y2 * coef1 + src.getCtrlY2() * coef1;
        double ctrlx12 = ctrlx1 * coef1 + centerxA * coef1;
        double ctrly12 = ctrly1 * coef1 + centeryA * coef1;
        double ctrlx21 = ctrlx2 * coef1 + centerxA * coef1;
        double ctrly21 = ctrly2 * coef1 + centeryA * coef1;
        double centerxB = ctrlx12 * coef1 + ctrlx21 * coef1;
        double centeryB = ctrly12 * coef1 + ctrly21 * coef1;
        left.setCurve(x1, y1, ctrlx1, ctrly1, ctrlx12, ctrly12, centerxB, centeryB);
        right.setCurve(centerxB, centeryB, ctrlx21, ctrly21, ctrlx2, ctrly2, x2, y2);
    }

    static double dist(XCubicCurve2D seg) {
        return XPoint2D.distance(seg.x1, seg.y1, seg.x2, seg.y2);
    }

    static double dist(XLine2D seg) {
        return XPoint2D.distance(seg.x1, seg.y1, seg.x2, seg.y2);
    }

    public static XPoint2D middle(XLine2D seg) {
        return new XPoint2D((seg.x1 + seg.x2) / 2.0, (seg.y1 + seg.y2) / 2.0);
    }

    public static XPoint2D middle(XPoint2D p1, XPoint2D p2) {
        return new XPoint2D((p1.getX() + p2.getX()) / 2.0, (p1.getY() + p2.getY()) / 2.0);
    }

    public static XPoint2D intersect(XLine2D orig, XRectangle2D shape) {
        XPoint2D m3;
        boolean containsMiddle;
        boolean contains2;
        XLine2D copy = new XLine2D(orig.x1, orig.y1, orig.x2, orig.y2);
        boolean contains1 = shape.contains(copy.x1, copy.y1);
        if (contains1 ^ !(contains2 = shape.contains(copy.x2, copy.y2))) {
            throw new IllegalArgumentException();
        }
        do {
            m3 = copy.getMiddle();
        } while (!(BezierUtils.dist(copy = contains1 == (containsMiddle = shape.contains(m3.x, m3.y)) ? copy.withPoint1(m3) : copy.withPoint2(m3)) < 0.1));
        if (contains1) {
            return copy.getP2();
        }
        if (contains2) {
            return copy.getP1();
        }
        throw new IllegalStateException();
    }

    private static XRectangle2D toRectangle(Positionable p) {
        XPoint2D point = p.getPosition();
        XDimension2D dim = p.getSize();
        return new XRectangle2D(point.getX(), point.getY(), dim.getWidth(), dim.getHeight());
    }

    public static boolean intersect(Positionable p1, Positionable p2) {
        return BezierUtils.toRectangle(p1).intersects(BezierUtils.toRectangle(p2));
    }

    public static XPoint2D getCenter(Positionable p) {
        return new XPoint2D(BezierUtils.toRectangle(p).getCenterX(), BezierUtils.toRectangle(p).getCenterY());
    }
}

