/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.shape;

import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;

public class TextBlockSprited
extends AbstractTextBlock {
    private final TextBlock parent;
    private final TextBlock sprite;

    public TextBlockSprited(TextBlock sprite, TextBlock parent) {
        this.sprite = sprite;
        this.parent = parent;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        double widthCircledCharacter = this.getCircledCharacterWithAndMargin(stringBounder);
        double heightCircledCharacter = this.sprite.calculateDimension(stringBounder).getHeight();
        XDimension2D dim = this.parent.calculateDimension(stringBounder);
        return new XDimension2D(dim.getWidth() + widthCircledCharacter, Math.max(heightCircledCharacter, dim.getHeight()));
    }

    private double getCircledCharacterWithAndMargin(StringBounder stringBounder) {
        return this.sprite.calculateDimension(stringBounder).getWidth() + 6.0;
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        this.sprite.drawU(ug);
        double widthCircledCharacter = this.getCircledCharacterWithAndMargin(stringBounder);
        this.parent.drawU(ug.apply(UTranslate.dx(widthCircledCharacter)));
    }
}

