/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.math;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.Icon;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.log.Logme;

public class ConverterSvg {
    private final Icon icon;
    private Dimension dimension;

    public ConverterSvg(Icon icon) {
        this.icon = icon;
    }

    public String getSvg(double scale, boolean fontAsShapes, Color backgroundColor) throws ClassNotFoundException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, InstantiationException, IOException {
        Class<?> clGenericDOMImplementation = Class.forName("znaishaded.org.apache.batik.dom.GenericDOMImplementation");
        DOMImplementation domImpl = (DOMImplementation)clGenericDOMImplementation.getMethod("getDOMImplementation", new Class[0]).invoke(null, new Object[0]);
        String svgNS = "http://www.w3.org/2000/svg";
        Document document = domImpl.createDocument("http://www.w3.org/2000/svg", "svg", null);
        Class<?> clSVGGeneratorContext = Class.forName("znaishaded.org.apache.batik.svggen.SVGGeneratorContext");
        Object ctx = clSVGGeneratorContext.getMethod("createDefault", Document.class).invoke(null, document);
        Class<?> clSVGGraphics2D = Class.forName("znaishaded.org.apache.batik.svggen.SVGGraphics2D");
        Graphics g2 = (Graphics)clSVGGraphics2D.getConstructor(clSVGGeneratorContext, Boolean.TYPE).newInstance(ctx, fontAsShapes);
        this.dimension = new Dimension(this.icon.getIconWidth(), this.icon.getIconHeight());
        g2.getClass().getMethod("setSVGCanvasSize", Dimension.class).invoke((Object)g2, this.dimension);
        if (backgroundColor != null) {
            g2.setColor(backgroundColor);
            g2.fillRect(0, 0, this.icon.getIconWidth(), this.icon.getIconHeight());
        }
        this.icon.paintIcon(null, g2, 0, 0);
        CharArrayWriter out = new CharArrayWriter();
        boolean useCSS = true;
        g2.getClass().getMethod("stream", Writer.class, Boolean.TYPE).invoke((Object)g2, out, true);
        ((Writer)out).flush();
        ((Writer)out).close();
        return ((Object)out).toString();
    }

    public XDimension2D getDimension() {
        return XDimension2D.fromDimension(this.dimension);
    }

    static {
        try {
            Class<?> clDefaultTeXFont = Class.forName("znaishaded.org.scilab.forge.jlatexmath.DefaultTeXFont");
            Class<?> clAlphabetRegistration = Class.forName("znaishaded.org.scilab.forge.jlatexmath.AlphabetRegistration");
            Method registerAlphabet = clDefaultTeXFont.getMethod("registerAlphabet", clAlphabetRegistration);
            registerAlphabet.invoke(null, Class.forName("znaishaded.org.scilab.forge.jlatexmath.cyrillic.CyrillicRegistration").newInstance());
            registerAlphabet.invoke(null, Class.forName("znaishaded.org.scilab.forge.jlatexmath.greek.GreekRegistration").newInstance());
        }
        catch (Exception e) {
            Logme.error(e);
        }
    }
}

