/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.mindmap;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.FileFormatOption;
import znaishaded.net.sourceforge.plantuml.UmlDiagram;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.core.DiagramDescription;
import znaishaded.net.sourceforge.plantuml.core.ImageData;
import znaishaded.net.sourceforge.plantuml.core.UmlSource;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.Rankdir;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.mindmap.IdeaShape;
import znaishaded.net.sourceforge.plantuml.mindmap.MindMap;
import znaishaded.net.sourceforge.plantuml.skin.SkinParam;
import znaishaded.net.sourceforge.plantuml.skin.UmlDiagramType;
import znaishaded.net.sourceforge.plantuml.utils.Direction;

public class MindMapDiagram
extends UmlDiagram {
    private final List<MindMap> mindmaps = new ArrayList<MindMap>();
    private boolean defaultDirection = true;
    private String first;

    public final void setDefaultDirection(Direction direction) {
        this.defaultDirection = direction == Direction.RIGHT || direction == Direction.DOWN;
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("MindMap");
    }

    public MindMapDiagram(UmlSource source) {
        super(source, UmlDiagramType.MINDMAP, null);
        ((SkinParam)this.getSkinParam()).setRankdir(Rankdir.LEFT_TO_RIGHT);
        this.mindmaps.add(new MindMap(this.getSkinParam()));
    }

    @Override
    protected ImageData exportDiagramInternal(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        return this.createImageBuilder(fileFormatOption).drawable(this.getTextBlock()).write(os);
    }

    @Override
    protected TextBlock getTextBlock() {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                for (MindMap mindmap : MindMapDiagram.this.mindmaps) {
                    mindmap.drawU(ug);
                    XDimension2D dim = mindmap.calculateDimension(ug.getStringBounder());
                    ug = ug.apply(UTranslate.dy(dim.getHeight()));
                }
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                double width = 0.0;
                double height = 0.0;
                for (MindMap mindmap : MindMapDiagram.this.mindmaps) {
                    XDimension2D dim = mindmap.calculateDimension(stringBounder);
                    height += dim.getHeight();
                    width = Math.max(width, dim.getWidth());
                }
                return new XDimension2D(width, height);
            }
        };
    }

    public CommandExecutionResult addIdea(HColor backColor, int level, Display label, IdeaShape shape) {
        return this.addIdea(backColor, level, label, shape, this.defaultDirection);
    }

    private MindMap last() {
        return this.mindmaps.get(this.mindmaps.size() - 1);
    }

    public CommandExecutionResult addIdea(HColor backColor, int level, Display label, IdeaShape shape, boolean direction) {
        String stereotype = label.getEndingStereotype();
        if (stereotype != null) {
            label = label.removeEndingStereotype();
        }
        if (this.last().isFull(level)) {
            this.mindmaps.add(new MindMap(this.getSkinParam()));
        }
        return this.last().addIdeaInternal(stereotype, backColor, level, label, shape, direction);
    }

    public CommandExecutionResult addIdea(String stereotype, HColor backColor, int level, Display label, IdeaShape shape) {
        if (this.last().isFull(level)) {
            this.mindmaps.add(new MindMap(this.getSkinParam()));
        }
        return this.last().addIdeaInternal(stereotype, backColor, level, label, shape, this.defaultDirection);
    }

    public int getSmartLevel(String type) {
        if (this.first == null) {
            this.first = type;
        }
        if (type.endsWith("**")) {
            type = type.replace('\t', ' ').trim();
        }
        if (!(type = type.replace('\t', ' ')).contains(" ")) {
            return type.length() - 1;
        }
        if (type.endsWith(this.first)) {
            return type.length() - this.first.length();
        }
        if (type.trim().length() == 1) {
            return type.length() - 1;
        }
        if (type.startsWith(this.first)) {
            return type.length() - this.first.length();
        }
        throw new UnsupportedOperationException("type=<" + type + ">[" + this.first + "]");
    }
}

