/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.salt.element;

import java.util.ArrayList;
import java.util.StringTokenizer;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColors;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.font.UFont;
import znaishaded.net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.ULine;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UPolygon;
import znaishaded.net.sourceforge.plantuml.klimt.shape.URectangle;
import znaishaded.net.sourceforge.plantuml.salt.element.AbstractElementText;
import znaishaded.net.sourceforge.plantuml.salt.element.Element;
import znaishaded.net.sourceforge.plantuml.style.ISkinSimple;

public class ElementDroplist
extends AbstractElementText
implements Element {
    private final int box = 12;
    private final TextBlock openDrop;

    public ElementDroplist(String text, UFont font, ISkinSimple spriteContainer) {
        super(ElementDroplist.extract(text), font, true, spriteContainer);
        StringTokenizer st = new StringTokenizer(text, "^");
        ArrayList<String> drop = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            drop.add(st.nextToken());
        }
        if (drop.size() > 0) {
            drop.remove(0);
        }
        this.openDrop = drop.size() == 0 ? null : Display.create(drop).create(this.getConfig(), HorizontalAlignment.LEFT, spriteContainer);
    }

    private static String extract(String text) {
        int idx = text.indexOf(94);
        if (idx == -1) {
            return text;
        }
        return text.substring(0, idx);
    }

    @Override
    public XDimension2D getPreferredDimension(StringBounder stringBounder, double x, double y) {
        XDimension2D dim = this.getTextDimensionAt(stringBounder, x + 2.0);
        return dim.delta(16.0, 4.0);
    }

    @Override
    public void drawU(UGraphic ug, int zIndex, XDimension2D dimToUse) {
        XDimension2D dim = this.getPreferredDimension(ug.getStringBounder(), 0.0, 0.0);
        ug = ug.apply(this.getBlack());
        if (zIndex == 0) {
            ug.apply(this.getColorEE().bg()).draw(URectangle.build(dim.getWidth() - 1.0, dim.getHeight() - 1.0));
            this.drawText(ug, 2.0, 2.0);
            double xline = dim.getWidth() - 12.0;
            ug.apply(UTranslate.dx(xline)).draw(ULine.vline(dim.getHeight() - 1.0));
            UPolygon poly = new UPolygon();
            poly.addPoint(0.0, 0.0);
            poly.addPoint(6.0, 0.0);
            XDimension2D dimText = this.getPureTextDimension(ug.getStringBounder());
            poly.addPoint(3.0, dimText.getHeight() - 8.0);
            ug.apply(HColors.changeBack(ug)).apply(new UTranslate(xline + 3.0, 6.0)).draw(poly);
        }
        if (this.openDrop != null) {
            XDimension2D dimOpen = this.openDrop.calculateDimension(ug.getStringBounder()).atLeast(dim.getWidth() - 1.0, 0.0);
            ug = ug.apply(UTranslate.dy(dim.getHeight() - 1.0));
            ug.apply(this.getColorEE().bg()).draw(URectangle.build(dimOpen.getWidth() - 1.0, dimOpen.getHeight() - 1.0));
            this.openDrop.drawU(ug);
        }
    }
}

