/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.command;

import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.regex.RegexOptional;
import znaishaded.net.sourceforge.plantuml.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import znaishaded.net.sourceforge.plantuml.utils.LineLocation;

public class CommandAutonumberIncrement
extends SingleLineCommand2<SequenceDiagram> {
    public CommandAutonumberIncrement() {
        super(CommandAutonumberIncrement.getConcat());
    }

    private static RegexConcat getConcat() {
        return RegexConcat.build(CommandAutonumberIncrement.class.getName(), RegexLeaf.start(), new RegexLeaf("autonumber"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("inc"), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("POS", "([A-Za-z])"))), RegexLeaf.spaceZeroOrMore(), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(SequenceDiagram diagram, LineLocation location, RegexResult arg) {
        String position = arg.get("POS", 0);
        if (position == null) {
            diagram.getAutoNumber().incrementIntermediate();
        } else {
            int pos = StringUtils.goLowerCase(position.charAt(0)) - 97;
            diagram.getAutoNumber().incrementIntermediate(pos);
        }
        return CommandExecutionResult.ok();
    }
}

