/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.teoz;

import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.real.Real;
import znaishaded.net.sourceforge.plantuml.real.RealUtils;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Event;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Note;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NotePosition;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NoteStyle;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.AbstractTile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.EventsHistoryMode;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.YGauge;
import znaishaded.net.sourceforge.plantuml.skin.Area;
import znaishaded.net.sourceforge.plantuml.skin.Component;
import znaishaded.net.sourceforge.plantuml.skin.ComponentType;
import znaishaded.net.sourceforge.plantuml.skin.Context2D;
import znaishaded.net.sourceforge.plantuml.skin.rose.Rose;
import znaishaded.net.sourceforge.plantuml.style.ISkinParam;

public class NoteTile
extends AbstractTile
implements Tile {
    private final LivingSpace livingSpace1;
    private final LivingSpace livingSpace2;
    private final Rose skin;
    private final ISkinParam skinParam;
    private final Note note;
    private final YGauge yGauge;

    @Override
    public Event getEvent() {
        return this.note;
    }

    @Override
    public double getContactPointRelative() {
        return this.getComponent(this.getStringBounder()).getPreferredHeight(this.getStringBounder()) / 2.0;
    }

    public NoteTile(StringBounder stringBounder, LivingSpace livingSpace1, LivingSpace livingSpace2, Note note, Rose skin, ISkinParam skinParam, YGauge currentY) {
        super(stringBounder, currentY);
        this.livingSpace1 = livingSpace1;
        this.livingSpace2 = livingSpace2;
        this.note = note;
        this.skin = skin;
        this.skinParam = skinParam;
        this.yGauge = YGauge.create(currentY.getMax(), this.getPreferredHeight());
    }

    @Override
    public YGauge getYGauge() {
        return this.yGauge;
    }

    private Component getComponent(StringBounder stringBounder) {
        Component comp = this.skin.createComponentNote(this.note.getUsedStyles(), this.getNoteComponentType(this.note.getNoteStyle()), this.note.getSkinParamBackcolored(this.skinParam), this.note.getDisplay(), this.note.getColors(), this.note.getPosition());
        return comp;
    }

    private ComponentType getNoteComponentType(NoteStyle noteStyle) {
        if (noteStyle == NoteStyle.HEXAGONAL) {
            return ComponentType.NOTE_HEXAGONAL;
        }
        if (noteStyle == NoteStyle.BOX) {
            return ComponentType.NOTE_BOX;
        }
        return ComponentType.NOTE;
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        Component comp = this.getComponent(stringBounder);
        XDimension2D dim = comp.getPreferredDimension(stringBounder);
        double x = this.getX(stringBounder).getCurrentValue();
        Area area = Area.create(this.getUsedWidth(stringBounder), dim.getHeight());
        ug = ug.apply(UTranslate.dx(x));
        comp.drawU(ug, area, (Context2D)((Object)ug));
    }

    private double getUsedWidth(StringBounder stringBounder) {
        Component comp = this.getComponent(stringBounder);
        XDimension2D dim = comp.getPreferredDimension(stringBounder);
        double width = dim.getWidth();
        if (this.note.getPosition() == NotePosition.OVER_SEVERAL) {
            double x1 = this.livingSpace1.getPosB(stringBounder).getCurrentValue();
            double x2 = this.livingSpace2.getPosD(stringBounder).getCurrentValue();
            double w = x2 - x1;
            if (width < w) {
                return w;
            }
        }
        return width;
    }

    private Real getX(StringBounder stringBounder) {
        NotePosition position = this.note.getPosition();
        double width = this.getUsedWidth(stringBounder);
        if (position == NotePosition.LEFT) {
            return this.livingSpace1.getPosC(stringBounder).addFixed(-width);
        }
        if (position == NotePosition.RIGHT) {
            int level = this.livingSpace1.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
            double dx = (double)level * 5.0;
            return this.livingSpace1.getPosC(stringBounder).addFixed(dx);
        }
        if (position == NotePosition.OVER_SEVERAL) {
            Real x1 = this.livingSpace1.getPosC(stringBounder);
            Real x2 = this.livingSpace2.getPosC(stringBounder);
            return RealUtils.middle(x1, x2).addFixed(-width / 2.0);
        }
        if (position == NotePosition.OVER) {
            return this.livingSpace1.getPosC(stringBounder).addFixed(-width / 2.0);
        }
        throw new UnsupportedOperationException(position.toString());
    }

    @Override
    public double getPreferredHeight() {
        Component comp = this.getComponent(this.getStringBounder());
        XDimension2D dim = comp.getPreferredDimension(this.getStringBounder());
        return dim.getHeight();
    }

    @Override
    public void addConstraints() {
    }

    @Override
    public Real getMinX() {
        Real result = this.getX(this.getStringBounder());
        if (this.note.getPosition() == NotePosition.OVER_SEVERAL) {
            Real x1 = this.livingSpace1.getPosB(this.getStringBounder());
            return RealUtils.min(result, x1);
        }
        return result;
    }

    @Override
    public Real getMaxX() {
        Real result = this.getX(this.getStringBounder()).addFixed(this.getUsedWidth(this.getStringBounder()));
        if (this.note.getPosition() == NotePosition.OVER_SEVERAL) {
            Real x2 = this.livingSpace2.getPosD(this.getStringBounder());
            return RealUtils.max(result, x2);
        }
        return result;
    }
}

