/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek.extremity;

import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XPoint2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UEllipse;
import znaishaded.net.sourceforge.plantuml.svek.extremity.Extremity;

class ExtremityParenthesis2
extends Extremity {
    private final XPoint2D contact;
    private final XPoint2D center;
    private final double ortho;
    private final double ang = 30.0;

    public ExtremityParenthesis2(XPoint2D contact, double ortho, XPoint2D p1) {
        this.contact = new XPoint2D(contact.getX(), contact.getY());
        this.ortho = ortho;
        double dx = p1.getX() - contact.getX();
        double dy = p1.getY() - contact.getY();
        double distance1 = Math.round(contact.distance(p1));
        double len = Math.round(distance1 + 7.0);
        this.center = new XPoint2D(contact.getX() + dx / distance1 * len, contact.getY() + dy / distance1 * len);
    }

    @Override
    public XPoint2D somePoint() {
        return this.contact;
    }

    @Override
    public void drawU(UGraphic ug) {
        double deg = -this.ortho * 180.0 / Math.PI + 90.0 - 30.0;
        double size = Math.round(this.contact.distance(this.center));
        UEllipse circle = new UEllipse(size * 2.0, size * 2.0, deg, 60.0);
        ug.apply(new UTranslate(this.center.getX() - size, this.center.getY() - size)).draw(circle);
    }
}

