/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek.extremity;

import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColors;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XPoint2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UPolygon;
import znaishaded.net.sourceforge.plantuml.svek.extremity.Extremity;

class ExtremityTriangle
extends Extremity {
    private UPolygon polygon = new UPolygon();
    private final boolean fill;
    private final HColor backgroundColor;
    private final XPoint2D contact;
    private final int decorationLength;

    @Override
    public XPoint2D somePoint() {
        return this.contact;
    }

    public ExtremityTriangle(XPoint2D p1, double angle, boolean fill, HColor backgroundColor, int xWing, int yAperture, int decorationLength) {
        this.backgroundColor = backgroundColor;
        this.fill = fill;
        this.contact = new XPoint2D(p1.getX(), p1.getY());
        this.decorationLength = decorationLength;
        angle = this.manageround(angle);
        this.polygon.addPoint(0.0, 0.0);
        this.polygon.addPoint(-xWing, -yAperture);
        this.polygon.addPoint(-xWing, yAperture);
        this.polygon.addPoint(0.0, 0.0);
        this.polygon.rotate(angle + 1.5707963267948966);
        this.polygon = this.polygon.translate(p1.getX(), p1.getY());
    }

    @Override
    public void drawU(UGraphic ug) {
        if (this.backgroundColor != null) {
            ug = ug.apply(this.backgroundColor.bg());
        } else if (this.fill) {
            ug = ug.apply(HColors.changeBack(ug));
        }
        ug.draw(this.polygon);
    }

    @Override
    public double getDecorationLength() {
        return this.decorationLength;
    }
}

