/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.commonmark.ext.footnotes.internal;

import java.util.List;
import znaishaded.org.commonmark.ext.footnotes.FootnoteDefinition;
import znaishaded.org.commonmark.node.Block;
import znaishaded.org.commonmark.node.DefinitionMap;
import znaishaded.org.commonmark.parser.block.AbstractBlockParser;
import znaishaded.org.commonmark.parser.block.BlockContinue;
import znaishaded.org.commonmark.parser.block.BlockParserFactory;
import znaishaded.org.commonmark.parser.block.BlockStart;
import znaishaded.org.commonmark.parser.block.MatchedBlockParser;
import znaishaded.org.commonmark.parser.block.ParserState;
import znaishaded.org.commonmark.text.Characters;

public class FootnoteBlockParser
extends AbstractBlockParser {
    private final FootnoteDefinition block;

    public FootnoteBlockParser(String label) {
        this.block = new FootnoteDefinition(label);
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public boolean canContain(Block childBlock) {
        return true;
    }

    @Override
    public BlockContinue tryContinue(ParserState parserState) {
        if (parserState.getIndent() >= 4) {
            return BlockContinue.atColumn(4);
        }
        return BlockContinue.none();
    }

    @Override
    public List<DefinitionMap<?>> getDefinitions() {
        DefinitionMap<FootnoteDefinition> map = new DefinitionMap<FootnoteDefinition>(FootnoteDefinition.class);
        map.putIfAbsent(this.block.getLabel(), this.block);
        return List.of(map);
    }

    public static class Factory
    implements BlockParserFactory {
        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            int labelStart;
            if (state.getIndent() >= 4) {
                return BlockStart.none();
            }
            int index = state.getNextNonSpaceIndex();
            CharSequence content = state.getLine().getContent();
            if (content.charAt(index) != '[' || index + 1 >= content.length()) {
                return BlockStart.none();
            }
            if (content.charAt(++index) != '^' || index + 1 >= content.length()) {
                return BlockStart.none();
            }
            ++index;
            for (index = labelStart = index; index < content.length(); ++index) {
                char c = content.charAt(index);
                switch (c) {
                    case ']': {
                        if (index > labelStart && index + 1 < content.length() && content.charAt(index + 1) == ':') {
                            String label = content.subSequence(labelStart, index).toString();
                            int afterSpaces = Characters.skipSpaceTab(content, index + 2, content.length());
                            return BlockStart.of(new FootnoteBlockParser(label)).atIndex(afterSpaces);
                        }
                        return BlockStart.none();
                    }
                    case '\u0000': 
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        return BlockStart.none();
                    }
                }
            }
            return BlockStart.none();
        }
    }
}

