/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.enterprise.remove;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;
import org.testingisdocumenting.znai.console.ConsoleOutputs;
import org.testingisdocumenting.znai.console.ansi.Color;
import org.testingisdocumenting.znai.enterprise.remove.OnRemoveFinishedServerHandler;
import org.testingisdocumenting.znai.server.ZnaiServerConfig;

public class OnRemoveDeleteCachedServerHandler
implements OnRemoveFinishedServerHandler {
    @Override
    public void onRemoveFinished(ZnaiServerConfig config, String docId, String actor) {
        Path docPath = config.getDeployRoot().resolve(docId);
        ConsoleOutputs.out((Object[])new Object[]{Color.BLUE, "deleting docs: ", Color.PURPLE, docId, Color.BLACK, " at ", Color.PURPLE, docPath});
        try {
            File docDirectory = docPath.toFile();
            if (docDirectory.exists()) {
                FileUtils.deleteDirectory((File)docDirectory);
            }
            ConsoleOutputs.out((Object[])new Object[]{Color.BLUE, "deleted docs: ", Color.PURPLE, docPath});
        }
        catch (IOException e) {
            ConsoleOutputs.out((Object[])new Object[]{Color.BLUE, "failed to delete docs: ", Color.PURPLE, docPath});
        }
    }
}

