/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.enterprise.authorization;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.testingisdocumenting.znai.enterprise.DocLifecycleListener;
import org.testingisdocumenting.znai.enterprise.EnterpriseComponentsRegistry;
import org.testingisdocumenting.znai.enterprise.authorization.AllowedUsersAndGroups;
import org.testingisdocumenting.znai.enterprise.authorization.UserIdDocId;
import org.testingisdocumenting.znai.enterprise.authorization.groups.AuthorizationGroupResolutionServices;
import org.testingisdocumenting.znai.server.auth.AuthorizationHandler;
import org.testingisdocumenting.znai.structure.DocMeta;

public class EnterpriseAuthorizationHandler
implements AuthorizationHandler,
DocLifecycleListener {
    private final Cache<UserIdDocId, Boolean> authorizedByIds;
    private final Map<String, AllowedUsersAndGroups> allowedUsersAndGroupsById = new ConcurrentHashMap<String, AllowedUsersAndGroups>();

    public EnterpriseAuthorizationHandler() {
        this.authorizedByIds = Caffeine.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();
        this.buildAllowedUsersAndGroupsCache();
    }

    public boolean isAuthorized(String userId, String docId) {
        if (AuthorizationGroupResolutionServices.isEmpty()) {
            return true;
        }
        AllowedUsersAndGroups allowedUsersAndGroups = this.allowedUsersAndGroupsById.get(docId);
        if (allowedUsersAndGroups == null || allowedUsersAndGroups.isEmpty()) {
            return true;
        }
        if (allowedUsersAndGroups.containsUser(userId)) {
            return true;
        }
        if (allowedUsersAndGroups.getAllowedGroups().isEmpty()) {
            return false;
        }
        Boolean present = (Boolean)this.authorizedByIds.get((Object)new UserIdDocId(userId, docId), userIdDocId -> this.authorized(allowedUsersAndGroups, userId));
        return present == null ? false : present;
    }

    @Override
    public void onDocUpdate(DocMeta docMeta) {
        this.allowedUsersAndGroupsById.put(docMeta.getId(), this.createAllowedUsersAndGroups(docMeta));
    }

    @Override
    public void onDocRemove(String docId) {
        this.allowedUsersAndGroupsById.remove(docId);
    }

    private void buildAllowedUsersAndGroupsCache() {
        EnterpriseComponentsRegistry.documentationStorage().list().forEach(this::associatedAllowedById);
    }

    private void associatedAllowedById(DocMeta docMeta) {
        this.allowedUsersAndGroupsById.put(docMeta.getId(), this.createAllowedUsersAndGroups(docMeta));
    }

    private AllowedUsersAndGroups createAllowedUsersAndGroups(DocMeta docMeta) {
        return new AllowedUsersAndGroups(new HashSet<String>(docMeta.getAllowedUsers()), new HashSet<String>(docMeta.getAllowedGroups()));
    }

    private Boolean authorized(AllowedUsersAndGroups allowedUsersAndGroups, String userId) {
        return allowedUsersAndGroups.getAllowedGroups().stream().anyMatch(group -> this.inGroup((String)group, userId));
    }

    private boolean inGroup(String group, String userId) {
        return AuthorizationGroupResolutionServices.groupContainsUser(group, userId);
    }
}

