/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.enterprise.docpreparation;

import org.apache.commons.lang3.StringUtils;
import org.testingisdocumenting.znai.enterprise.EnterpriseComponentsRegistry;
import org.testingisdocumenting.znai.enterprise.storage.DocumentationFileBasedTimestamp;
import org.testingisdocumenting.znai.server.docpreparation.DocumentationPreparationHandler;
import org.testingisdocumenting.znai.server.docpreparation.DocumentationPreparationHandlers;
import org.testingisdocumenting.znai.server.docpreparation.DocumentationPreparationProgress;

public class StorageBasedDocumentationPreparationHandler
implements DocumentationPreparationHandler {
    private static final String SERVER_URL = System.getProperty("znai.server.url");

    public boolean handles(String docId) {
        return EnterpriseComponentsRegistry.enterpriseConfig().getDocStorageRoot() != null && EnterpriseComponentsRegistry.documentationStorage().contains(docId);
    }

    public boolean isReady(String docId) {
        long currentTimestamp;
        long storageUpdateTime = EnterpriseComponentsRegistry.documentationStorage().lastUpdateTime(docId, "");
        return storageUpdateTime <= (currentTimestamp = DocumentationFileBasedTimestamp.read(EnterpriseComponentsRegistry.serverConfig().getDeployRoot().resolve(docId)));
    }

    public void prepare(String docId, DocumentationPreparationProgress preparationProgress) {
        EnterpriseComponentsRegistry.documentationStorage().prepare(docId, "", preparationProgress);
    }

    static {
        if (StringUtils.isNotBlank((CharSequence)SERVER_URL)) {
            DocumentationPreparationHandlers.add((DocumentationPreparationHandler)new StorageBasedDocumentationPreparationHandler());
        }
    }
}

