/*
 * Copyright 2020 znai maintainers
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.testingisdocumenting.znai.enterprise.storage;

import org.testingisdocumenting.znai.utils.FileUtils;

import java.nio.file.Files;
import java.nio.file.Path;

public class DocumentationFileBasedTimestamp {
    public static final String TIMESTAMP_FILE_NAME = "timestamp";

    private DocumentationFileBasedTimestamp() {
    }

    public static void store(Path docPath) {
        FileUtils.writeTextContent(docPath.resolve(TIMESTAMP_FILE_NAME), String.valueOf(System.currentTimeMillis()));
    }

    public static long read(Path docPath) {
        Path timestampPath = docPath.resolve(TIMESTAMP_FILE_NAME);

        return Files.exists(timestampPath) ?
                Long.parseLong(FileUtils.fileTextContent(timestampPath)) :
                0;
    }
}
