/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.enterprise;

import org.testingisdocumenting.znai.enterprise.DocLifecycleListeners;
import org.testingisdocumenting.znai.enterprise.ZnaiEnterpriseConfig;
import org.testingisdocumenting.znai.enterprise.authorization.EnterpriseAuthorizationHandler;
import org.testingisdocumenting.znai.enterprise.authorization.groups.AuthorizationGroupResolutionServices;
import org.testingisdocumenting.znai.enterprise.authorization.groups.NixAuthorizationGroupResolutionService;
import org.testingisdocumenting.znai.enterprise.landing.LandingDocEntriesProviders;
import org.testingisdocumenting.znai.enterprise.landing.StorageBasedLandingDocEntriesProvider;
import org.testingisdocumenting.znai.enterprise.storage.DocumentationStorage;
import org.testingisdocumenting.znai.enterprise.storage.DocumentationStorageFactories;
import org.testingisdocumenting.znai.server.ServerLifecycleListener;
import org.testingisdocumenting.znai.server.ZnaiServerConfig;
import org.testingisdocumenting.znai.server.auth.AuthorizationHandler;
import org.testingisdocumenting.znai.server.auth.AuthorizationHandlers;

public class EnterpriseComponentsRegistry
implements ServerLifecycleListener {
    private static final ZnaiEnterpriseConfig enterpriseConfig = new ZnaiEnterpriseConfig();
    private static ZnaiServerConfig serverConfig;
    private static DocumentationStorage documentationStorage;

    public static DocumentationStorage documentationStorage() {
        return documentationStorage;
    }

    public static ZnaiEnterpriseConfig enterpriseConfig() {
        return enterpriseConfig;
    }

    public static ZnaiServerConfig serverConfig() {
        return serverConfig;
    }

    public void beforeStart(ZnaiServerConfig config) {
        serverConfig = config;
        documentationStorage = EnterpriseComponentsRegistry.createStorage();
        this.registerLanding();
        this.registerAuthorization();
    }

    private static DocumentationStorage createStorage() {
        return DocumentationStorageFactories.create(serverConfig);
    }

    private void registerLanding() {
        StorageBasedLandingDocEntriesProvider entriesProvider = new StorageBasedLandingDocEntriesProvider();
        LandingDocEntriesProviders.add(entriesProvider);
        DocLifecycleListeners.add(entriesProvider);
    }

    private void registerAuthorization() {
        EnterpriseAuthorizationHandler authorizationHandler = new EnterpriseAuthorizationHandler();
        AuthorizationHandlers.add((AuthorizationHandler)authorizationHandler);
        DocLifecycleListeners.add(authorizationHandler);
        if (enterpriseConfig.getAuthGroupsResolutionType().equals("nix-groups")) {
            AuthorizationGroupResolutionServices.add(new NixAuthorizationGroupResolutionService());
        }
    }
}

