/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.enterprise.monitoring;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.tools.ant.DirectoryScanner;
import org.testingisdocumenting.znai.console.ConsoleOutputs;
import org.testingisdocumenting.znai.console.ansi.Color;
import org.testingisdocumenting.znai.enterprise.monitoring.BuildRootAndWildCardPatterns;

public class FilesFinder {
    private final List<BuildRootAndWildCardPatterns> buildRootAndWildCardPatterns;

    public FilesFinder(List<BuildRootAndWildCardPatterns> buildRootAndWildCardPatterns) {
        this.buildRootAndWildCardPatterns = buildRootAndWildCardPatterns;
    }

    public List<Path> find() {
        return this.buildRootAndWildCardPatterns.stream().flatMap(rootAndPatterns -> this.find((BuildRootAndWildCardPatterns)rootAndPatterns).stream()).collect(Collectors.toList());
    }

    private List<Path> find(BuildRootAndWildCardPatterns buildRootAndWildCardPatterns) {
        ConsoleOutputs.out((Object[])new Object[]{"scanning ", Color.PURPLE, buildRootAndWildCardPatterns.getBuildRoot(), Color.WHITE, " patterns\n  ", String.join((CharSequence)"\n  ", buildRootAndWildCardPatterns.getWildCardPatterns())});
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(buildRootAndWildCardPatterns.getBuildRoot().toFile());
        scanner.setIncludes(buildRootAndWildCardPatterns.getWildCardPatterns().toArray(new String[0]));
        scanner.scan();
        return Arrays.stream(scanner.getIncludedFiles()).map(filePath -> buildRootAndWildCardPatterns.getBuildRoot().resolve((String)filePath)).collect(Collectors.toList());
    }
}

