/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.enterprise.log;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testingisdocumenting.znai.console.ConsoleOutput;
import org.testingisdocumenting.znai.console.ansi.IgnoreAnsiString;

public class RedirectToFileConsoleOutput
implements ConsoleOutput {
    private static final Logger logger = RedirectToFileConsoleOutput.createLogger();

    public void out(Object ... styleOrValues) {
        if (logger == null) {
            return;
        }
        logger.info(RedirectToFileConsoleOutput.stripAnsi(styleOrValues));
    }

    public void err(Object ... styleOrValues) {
        if (logger == null) {
            return;
        }
        logger.error(RedirectToFileConsoleOutput.stripAnsi(styleOrValues));
    }

    private static Logger createLogger() {
        String logPathBase = System.getProperty("logPath");
        if (logPathBase == null) {
            return null;
        }
        return LoggerFactory.getLogger(RedirectToFileConsoleOutput.class);
    }

    private static String stripAnsi(Object[] styleOrValues) {
        return new IgnoreAnsiString(styleOrValues).toString();
    }
}

