/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.enterprise;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import org.testingisdocumenting.znai.server.auth.AuthorizationRequestLink;
import org.testingisdocumenting.znai.utils.FileUtils;
import org.testingisdocumenting.znai.utils.JsonUtils;

public class ZnaiEnterpriseConfig {
    private static final String CONFIG_FILE_NAME = "znai-enterprise.cfg";
    private final Path fsMonitorConfigPath;
    private final Path docStorageRoot;
    private final String authzGroupsResolutionType;
    private final AuthorizationRequestLink authzRequestLink;
    private final Map<String, Object> jsonConfig = this.getJsonConfig();

    public ZnaiEnterpriseConfig() {
        this.fsMonitorConfigPath = this.buildFsMonitorConfigPath();
        this.docStorageRoot = this.buildDocStorageRoot();
        this.authzGroupsResolutionType = this.configValueOrDefault("authzGroupsResolutionType", "");
        this.authzRequestLink = new AuthorizationRequestLink(this.configValueOrDefault("authzRequestMessage", ""), this.configValueOrDefault("authzRequestLink", ""));
    }

    public Path getFsMonitorConfigPath() {
        return this.fsMonitorConfigPath;
    }

    public Path getDocStorageRoot() {
        return this.docStorageRoot;
    }

    public String getAuthzGroupsResolutionType() {
        return this.authzGroupsResolutionType;
    }

    public AuthorizationRequestLink getAuthzRequestLink() {
        return this.authzRequestLink;
    }

    private Path buildFsMonitorConfigPath() {
        return Paths.get(this.configValueOrDefault("znaiFsMonitorConfig", "monitor.config.json"), new String[0]);
    }

    private Path buildDocStorageRoot() {
        String docStoragePath = this.configValueOrDefault("znaiDocStoragePath", "");
        return docStoragePath.isEmpty() ? null : Paths.get(docStoragePath, new String[0]);
    }

    private String configValueOrDefault(String key, String defaultValue) {
        return ZnaiEnterpriseConfig.systemPropertyOrDefault(key, this.jsonConfig.getOrDefault(key, defaultValue).toString());
    }

    private static String systemPropertyOrDefault(String key, String defaultValue) {
        return System.getProperty(key, defaultValue);
    }

    private Map<String, Object> getJsonConfig() {
        Path configPath = Paths.get(CONFIG_FILE_NAME, new String[0]);
        return Files.exists(configPath, new LinkOption[0]) ? JsonUtils.deserializeAsMap((String)FileUtils.fileTextContent((Path)configPath)) : Collections.emptyMap();
    }
}

