/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.enterprise.upload;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.file.AsyncFile;
import io.vertx.core.file.OpenOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.streams.Pump;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.testingisdocumenting.znai.enterprise.upload.OnUploadFinishedServerHandlers;
import org.testingisdocumenting.znai.server.ZnaiServerConfig;

public class DocumentationUploadVertxHandler
implements Handler<HttpServerRequest> {
    private final Vertx vertx;
    private final ZnaiServerConfig config;
    private final String docId;
    private final Path destination;
    private final String actor;

    public DocumentationUploadVertxHandler(Vertx vertx, ZnaiServerConfig config, String docId, String actor) {
        this.vertx = vertx;
        this.config = config;
        this.docId = docId;
        this.destination = config.getDeployRoot().resolve(docId + ".zip").toAbsolutePath();
        this.actor = actor;
    }

    public void handle(HttpServerRequest req) {
        req.pause();
        this.vertx.fileSystem().open(this.destination.toString(), new OpenOptions(), fh -> {
            AsyncFile file = (AsyncFile)fh.result();
            Pump pump = Pump.pump((ReadStream)req, (WriteStream)file);
            req.endHandler(eh -> file.close(fch -> {
                req.response().end();
                OnUploadFinishedServerHandlers.onUploadFinished(this.config, this.docId, this.destination, this.actor);
                this.deleteUploadedFile();
            }));
            pump.start();
            req.resume();
        });
    }

    private void deleteUploadedFile() {
        try {
            Files.delete(this.destination);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

