/*
 * Copyright 2020 znai maintainers
 * Copyright 2019 TWO SIGMA OPEN SOURCE, LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.testingisdocumenting.znai.enterprise.landing;

import org.testingisdocumenting.znai.html.HtmlPage;
import org.testingisdocumenting.znai.html.reactjs.HtmlReactJsPage;
import org.testingisdocumenting.znai.html.reactjs.ReactJsBundle;
import org.testingisdocumenting.znai.server.FavIcons;
import org.testingisdocumenting.znai.server.UrlContentHandler;
import io.vertx.ext.web.RoutingContext;
import org.testingisdocumenting.znai.server.ZnaiServerConfig;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class LandingUrlContentHandler implements UrlContentHandler {
    public LandingUrlContentHandler() {
    }

    @Override
    public String url() {
        return "/";
    }

    @Override
    public String buildContent(ZnaiServerConfig serverConfig, RoutingContext ctx, ReactJsBundle reactJsBundle) {
        List<Map<String, Object>> documentations = LandingDocEntriesProviders.provide()
                .map(LandingDocEntry::toMap)
                .collect(Collectors.toList());

        HtmlReactJsPage htmlReactJsPage = new HtmlReactJsPage(reactJsBundle);

        Map<String, Object> props = new LinkedHashMap<>();
        props.put("documentations", documentations);
        props.put("type", serverConfig.getServerType());
        props.put("title", serverConfig.getServerTitle());

        HtmlPage htmlPage = htmlReactJsPage.create(serverConfig.getServerTitle() + " " + serverConfig.getServerType(),
                "Landing", props, () -> "", FavIcons.DEFAULT_ICON_PATH);
        return htmlPage.render("");
    }
}
