/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.enterprise.upload;

import java.nio.file.Path;
import org.testingisdocumenting.znai.console.ConsoleOutputs;
import org.testingisdocumenting.znai.console.ansi.Color;
import org.testingisdocumenting.znai.core.DocMeta;
import org.testingisdocumenting.znai.enterprise.DocLifecycleListeners;
import org.testingisdocumenting.znai.enterprise.EnterpriseComponentsRegistry;
import org.testingisdocumenting.znai.enterprise.upload.OnUploadFinishedServerHandler;
import org.testingisdocumenting.znai.fs.FsUtils;
import org.testingisdocumenting.znai.server.ZnaiServerConfig;
import org.testingisdocumenting.znai.utils.FileUtils;

public class UnzipAndStoreOnUploadFinishedServerHandler
implements OnUploadFinishedServerHandler {
    @Override
    public void onUploadFinished(ZnaiServerConfig config, String docId, Path uploadedPath, String actor) {
        Path unzipDest = config.getDeployRoot().resolve(docId);
        ConsoleOutputs.out((Object[])new Object[]{Color.BLUE, "unzipping docs: ", Color.PURPLE, uploadedPath, Color.BLACK, " to ", Color.PURPLE, unzipDest});
        FsUtils.unzip(uploadedPath, unzipDest);
        ConsoleOutputs.out((Object[])new Object[]{Color.BLUE, "unzipped docs: ", Color.PURPLE, unzipDest});
        EnterpriseComponentsRegistry.documentationStorage().store(actor, docId, "", unzipDest);
        DocLifecycleListeners.onDocUpdate(new DocMeta(FileUtils.fileTextContent((Path)unzipDest.resolve("meta.json"))));
    }
}

