/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.enterprise.storage;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.console.ConsoleOutputs;
import org.testingisdocumenting.znai.console.ansi.Color;
import org.testingisdocumenting.znai.core.DocMeta;
import org.testingisdocumenting.znai.enterprise.storage.DocumentationFileBasedTimestamp;
import org.testingisdocumenting.znai.enterprise.storage.DocumentationStorage;
import org.testingisdocumenting.znai.fs.FsUtils;
import org.testingisdocumenting.znai.server.docpreparation.DocumentationPreparationProgress;
import org.testingisdocumenting.znai.utils.FileUtils;

public class FileBasedDocumentationStorage
implements DocumentationStorage {
    private final Path storageRoot;
    private final Path docsRoot;

    public FileBasedDocumentationStorage(Path storageRoot, Path docsRootPath) {
        this.storageRoot = storageRoot;
        this.docsRoot = docsRootPath;
    }

    @Override
    public boolean contains(String docId) {
        Path src = this.storageRoot.resolve(docId).resolve("");
        return Files.exists(src, new LinkOption[0]);
    }

    @Override
    public synchronized void store(String actor, String docId, String version, Path generatedDocumentation) {
        Path dest = this.storageRoot.resolve(docId).resolve(version);
        FsUtils.deleteDirectory(dest);
        FsUtils.copyDirectory(generatedDocumentation, dest);
        DocumentationFileBasedTimestamp.store(dest);
        ConsoleOutputs.out((Object[])new Object[]{"stored ", Color.WHITE, docId, Color.BLUE, " as ", Color.PURPLE, dest});
    }

    @Override
    public synchronized void prepare(String docId, String version, DocumentationPreparationProgress progress) {
        progress.reportProgress("Checking documentation", Collections.emptyMap(), 10);
        Path src = this.storageRoot.resolve(docId).resolve(version);
        Path tempDestRoot = this.creteTempDir();
        Path tempDest = tempDestRoot.resolve(docId).resolve(version);
        Path finalDest = this.docsRoot.resolve(docId).resolve(version);
        FsUtils.deleteDirectory(tempDest);
        FsUtils.copyDirectory(src, tempDest);
        progress.reportProgress("Moved documentation to a temporary location", Collections.emptyMap(), 40);
        progress.reportProgress("Moving documentation to a permanent location", Collections.emptyMap(), 80);
        FsUtils.deleteDirectory(finalDest);
        FsUtils.moveDirectory(tempDest, finalDest);
        FsUtils.deleteDirectory(tempDestRoot);
        progress.reportProgress("Moved documentation to a permanent location", Collections.emptyMap(), 100);
    }

    private Path creteTempDir() {
        try {
            return Files.createTempDirectory(this.docsRoot, "temp", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long lastUpdateTime(String docId, String version) {
        return DocumentationFileBasedTimestamp.read(this.storageRoot.resolve(docId).resolve(version));
    }

    @Override
    public void remove(String actor, String docId) {
        if (this.contains(docId)) {
            Path src = this.storageRoot.resolve(docId).resolve("");
            try {
                Files.delete(src);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public List<DocMeta> list() {
        try {
            return Files.list(this.storageRoot).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(file -> Files.exists(file.resolve("meta.json"), new LinkOption[0])).map(file -> file.resolve("meta.json")).map(fileMeta -> new DocMeta(FileUtils.fileTextContent((Path)fileMeta))).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

