/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.enterprise.docpreparation;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.enterprise.docpreparation.DocumentationPreparationSocketProgress;
import org.testingisdocumenting.znai.server.docpreparation.DocumentationPreparationHandlers;
import org.testingisdocumenting.znai.server.docpreparation.DocumentationPreparationProgress;
import org.testingisdocumenting.znai.server.sockets.JsonWebSocketHandler;
import org.testingisdocumenting.znai.utils.CollectionUtils;

public class DocumentationPreparationWebSocketHandler
extends JsonWebSocketHandler {
    public DocumentationPreparationWebSocketHandler() {
        super("documentation update", "/_doc-update", message -> {});
    }

    public void sendUpdate(String docId, String message, Map<String, String> keyValues, int progressPercent) {
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("message", message);
        payload.put("progress", progressPercent);
        List keyValuesList = keyValues.keySet().stream().map(key -> CollectionUtils.createMap((Object[])new Object[]{"key", key, "value", keyValues.get(key)})).collect(Collectors.toList());
        payload.put("keyValues", keyValuesList);
        this.send("/" + docId, payload);
    }

    public void onConnect(String uri) {
        int lastSepIdx = uri.lastIndexOf(47);
        String docId = uri.substring(lastSepIdx + 1);
        this.vertx.executeBlocking(future -> DocumentationPreparationHandlers.prepare((String)docId, (DocumentationPreparationProgress)new DocumentationPreparationSocketProgress(docId, this)), false, res -> {});
    }
}

