/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.enterprise.monitoring;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.enterprise.monitoring.BuildRootAndWildCardPatterns;

public class MonitorConfig {
    private final int intervalMillis;
    private final List<BuildRootAndWildCardPatterns> buildRootsAndPatterns;

    public MonitorConfig(Map<String, Object> config) {
        this.intervalMillis = MonitorConfig.extractInterval(config, (int)TimeUnit.MINUTES.toMillis(1L));
        this.buildRootsAndPatterns = MonitorConfig.extractRootAndPatterns(config);
    }

    public long getIntervalMillis() {
        return this.intervalMillis;
    }

    public List<BuildRootAndWildCardPatterns> getBuildRootsAndPatterns() {
        return this.buildRootsAndPatterns;
    }

    private static Path extractRootDir(Map<String, Object> config) {
        return Paths.get(config.getOrDefault("rootDir", "").toString(), new String[0]);
    }

    private static int extractInterval(Map<String, Object> config, int defaultValue) {
        return (Integer)config.getOrDefault("intervalMillis", defaultValue);
    }

    private static List<BuildRootAndWildCardPatterns> extractRootAndPatterns(Map<String, Object> config) {
        List paths = config.getOrDefault("paths", Collections.emptyList());
        return paths.stream().map(rootAndPatterns -> new BuildRootAndWildCardPatterns(MonitorConfig.extractRootDir(rootAndPatterns), MonitorConfig.extractWildCardPatterns(rootAndPatterns))).collect(Collectors.toList());
    }

    private static List<String> extractWildCardPatterns(Map<String, Object> config) {
        return config.getOrDefault("wildCardPatterns", Collections.emptyList());
    }
}

