/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.java.extensions;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.api.ApiParameters;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.java.extensions.JavaIncludePluginBase;
import org.testingisdocumenting.znai.java.extensions.JavaIncludeResult;
import org.testingisdocumenting.znai.java.parser.JavaCode;
import org.testingisdocumenting.znai.java.parser.JavaMethod;
import org.testingisdocumenting.znai.java.parser.JavaMethodReturn;

public class JavaDocParamsIncludePlugin
extends JavaIncludePluginBase {
    public String id() {
        return "java-doc-params";
    }

    public IncludePlugin create() {
        return new JavaDocParamsIncludePlugin();
    }

    @Override
    public JavaIncludeResult process(JavaCode javaCode) {
        JavaMethod javaMethod = javaCode.findMethod(this.entry);
        ApiParameters apiParameters = new ApiParameters();
        this.addReturn(apiParameters, javaMethod);
        javaMethod.getParams().forEach(param -> apiParameters.add(param.getName(), param.getType(), this.javaDocTextToDocElements(param.getJavaDocText())));
        Map props = apiParameters.toMap();
        this.codeReferencesFeature.updateProps(props);
        props.putAll(this.pluginParams.getOpts().toMap());
        List docElements = PluginResult.docElement((String)"ApiParameters", (Map)props).getDocElements();
        return new JavaIncludeResult(docElements, this.extractText(javaMethod));
    }

    private String extractText(JavaMethod javaMethod) {
        JavaMethodReturn methodReturn = javaMethod.getJavaMethodReturn();
        String returnPart = methodReturn != null ? "return " + methodReturn.getType() + " " + methodReturn.getJavaDocText() : "";
        String paramsPart = javaMethod.getParams().stream().map(p -> p.getName() + " " + p.getType() + " " + p.getJavaDocText()).collect(Collectors.joining(" "));
        return paramsPart + (returnPart.isEmpty() ? "" : " ") + returnPart;
    }

    private void addReturn(ApiParameters apiParameters, JavaMethod javaMethod) {
        JavaMethodReturn methodReturn = javaMethod.getJavaMethodReturn();
        if (methodReturn == null) {
            return;
        }
        apiParameters.add("return", methodReturn.getType(), this.javaDocTextToDocElements(methodReturn.getJavaDocText()));
    }
}

