/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.java.extensions;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.api.ApiParameters;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.java.extensions.JavaIncludePluginBase;
import org.testingisdocumenting.znai.java.extensions.JavaIncludeResult;
import org.testingisdocumenting.znai.java.parser.EnumEntry;
import org.testingisdocumenting.znai.java.parser.JavaCode;
import org.testingisdocumenting.znai.java.parser.html.HtmlToDocElementConverter;
import org.testingisdocumenting.znai.parser.docelement.DocElement;

public class JavaEnumEntriesIncludePlugin
extends JavaIncludePluginBase {
    public String id() {
        return "java-enum-entries";
    }

    public IncludePlugin create() {
        return new JavaEnumEntriesIncludePlugin();
    }

    @Override
    public JavaIncludeResult process(JavaCode javaCode) {
        ApiParameters apiParameters = new ApiParameters();
        javaCode.getEnumEntries().stream().filter(this::includeEnum).forEach(enumEntry -> apiParameters.add(enumEntry.getName(), "", this.javaDocTextToDocElements(enumEntry.getJavaDocText())));
        Map props = apiParameters.toMap();
        this.features.updateProps(props);
        props.putAll(this.pluginParams.getOpts().toMap());
        List docElements = PluginResult.docElement((String)"ApiParameters", (Map)props).getDocElements();
        return new JavaIncludeResult(docElements, this.extractText(javaCode.getEnumEntries()));
    }

    private boolean includeEnum(EnumEntry enumEntry) {
        boolean excludeDeprecated = (Boolean)this.pluginParams.getOpts().get("excludeDeprecated", (Object)false);
        return !excludeDeprecated || !enumEntry.isDeprecated();
    }

    private String extractText(List<EnumEntry> enums) {
        return enums.stream().map(e -> e.getName() + " " + e.getJavaDocText()).collect(Collectors.joining(" "));
    }

    private List<Map<String, Object>> nameToDocElements(EnumEntry e) {
        return Collections.singletonList(new DocElement("InlinedCode", new Object[]{"code", e.getName()}).toMap());
    }

    private List<Map<String, Object>> descriptionToDocElements(EnumEntry e) {
        return HtmlToDocElementConverter.convert(this.componentsRegistry, this.markupPath, e.getJavaDocText(), this.codeReferencesFeature.getReferences()).stream().map(DocElement::toMap).collect(Collectors.toList());
    }
}

