/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.java.parser.html;

import java.nio.file.Path;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.NodeVisitor;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.parser.docelement.DocElement;
import org.testingisdocumenting.znai.parser.docelement.DocElementCreationParserHandler;
import org.testingisdocumenting.znai.reference.DocReferences;

public class HtmlToDocElementConverter {
    private HtmlToDocElementConverter() {
    }

    public static List<DocElement> convert(ComponentsRegistry componentsRegistry, Path filePath, String html, DocReferences codeReferences) {
        Document document = Jsoup.parse((String)html);
        DocElementCreationParserHandler parserHandler = new DocElementCreationParserHandler(componentsRegistry, filePath);
        document.body().traverse((NodeVisitor)new ConverterNodeVisitor((ParserHandler)parserHandler, codeReferences));
        parserHandler.onParsingEnd();
        return parserHandler.getDocElement().getContent();
    }

    private static class ConverterNodeVisitor
    implements NodeVisitor {
        private ParserHandler parserHandler;
        private DocReferences codeReferences;
        private boolean isInsideInlinedCode;
        private boolean isInsideBlockCode;
        private boolean isInsideParagraph;

        ConverterNodeVisitor(ParserHandler parserHandler, DocReferences codeReferences) {
            this.parserHandler = parserHandler;
            this.codeReferences = codeReferences;
            this.startParagraphIfRequired();
        }

        public void head(Node node, int i) {
            if (ConverterNodeVisitor.isParagraph(node)) {
                this.closeParagraphIfRequired();
                this.startParagraph();
            } else if (ConverterNodeVisitor.isInlinedCode(node)) {
                this.isInsideInlinedCode = true;
            } else if (ConverterNodeVisitor.isBlockCode(node)) {
                this.isInsideBlockCode = true;
            } else if (ConverterNodeVisitor.isBold(node)) {
                this.parserHandler.onStrongEmphasisStart();
            } else if (ConverterNodeVisitor.isItalic(node)) {
                this.parserHandler.onEmphasisStart();
            } else if (ConverterNodeVisitor.isLink(node)) {
                this.parserHandler.onLinkStart(node.attr("href"));
            } else if (ConverterNodeVisitor.isUnorderedList(node)) {
                this.closeParagraphIfRequired();
                this.parserHandler.onBulletListStart('*', false);
            } else if (ConverterNodeVisitor.isOrderedList(node)) {
                this.closeParagraphIfRequired();
                this.parserHandler.onOrderedListStart('.', 1);
            } else if (ConverterNodeVisitor.isListItem(node)) {
                this.parserHandler.onListItemStart();
            } else if (node.nodeName().equals("#text")) {
                TextNode textNode = (TextNode)node;
                this.handleText(textNode.text());
            }
        }

        public void tail(Node node, int i) {
            if (ConverterNodeVisitor.isParagraph(node)) {
                this.closeParagraphIfRequired();
            } else if (ConverterNodeVisitor.isInlinedCode(node)) {
                this.isInsideInlinedCode = false;
            } else if (ConverterNodeVisitor.isBlockCode(node)) {
                this.isInsideBlockCode = false;
            } else if (ConverterNodeVisitor.isBold(node)) {
                this.parserHandler.onStrongEmphasisEnd();
            } else if (ConverterNodeVisitor.isItalic(node)) {
                this.parserHandler.onEmphasisEnd();
            } else if (ConverterNodeVisitor.isLink(node)) {
                this.parserHandler.onLinkEnd();
            } else if (ConverterNodeVisitor.isUnorderedList(node)) {
                this.parserHandler.onBulletListEnd();
                this.closeParagraphIfRequired();
                this.startParagraph();
            } else if (ConverterNodeVisitor.isOrderedList(node)) {
                this.parserHandler.onOrderedListEnd();
                this.closeParagraphIfRequired();
                this.startParagraph();
            } else if (ConverterNodeVisitor.isListItem(node)) {
                this.parserHandler.onListItemEnd();
            }
        }

        private void handleText(String text) {
            if (text.trim().isEmpty()) {
                return;
            }
            if (this.isInsideInlinedCode) {
                this.parserHandler.onInlinedCode(text, this.codeReferences);
            } else if (this.isInsideBlockCode) {
                this.closeParagraphIfRequired();
                this.parserHandler.onSnippet(PluginParams.EMPTY, "", "", text);
            } else {
                this.parserHandler.onSimpleText(text);
            }
        }

        private void startParagraphIfRequired() {
            if (this.isInsideParagraph) {
                return;
            }
            this.startParagraph();
        }

        private void startParagraph() {
            this.isInsideParagraph = true;
            this.parserHandler.onParagraphStart();
        }

        private void closeParagraphIfRequired() {
            if (this.isInsideParagraph) {
                this.parserHandler.onParagraphEnd();
                this.isInsideParagraph = false;
            }
        }

        private static boolean isParagraph(Node node) {
            return node.nodeName().equals("p");
        }

        private static boolean isBlockCode(Node node) {
            return node.nodeName().equals("pre");
        }

        private static boolean isUnorderedList(Node node) {
            return node.nodeName().equals("ul");
        }

        private static boolean isOrderedList(Node node) {
            return node.nodeName().equals("ol");
        }

        private static boolean isListItem(Node node) {
            return node.nodeName().equals("li");
        }

        private static boolean isBold(Node node) {
            return node.nodeName().equals("b");
        }

        private static boolean isItalic(Node node) {
            return node.nodeName().equals("i");
        }

        private static boolean isInlinedCode(Node node) {
            return node.nodeName().equals("code");
        }

        private static boolean isLink(Node node) {
            return node.nodeName().equals("a");
        }
    }
}

