/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.java.extensions;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.api.ApiParameters;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.java.extensions.JavaIncludePluginBase;
import org.testingisdocumenting.znai.java.extensions.JavaIncludeResult;
import org.testingisdocumenting.znai.java.parser.EnumEntry;
import org.testingisdocumenting.znai.java.parser.JavaCode;

public class JavaEnumEntriesIncludePlugin
extends JavaIncludePluginBase {
    public String id() {
        return "java-enum-entries";
    }

    public IncludePlugin create() {
        return new JavaEnumEntriesIncludePlugin();
    }

    @Override
    public JavaIncludeResult process(JavaCode javaCode) {
        ApiParameters apiParameters = new ApiParameters(this.determineAnchorPrefix());
        javaCode.getEnumEntries().stream().filter(this::includeEnum).forEach(enumEntry -> {
            JavaIncludePluginBase.JavaDocElementsMapsAndSearchText elementsMapsAndSearchText = this.javaDocTextToDocElements(enumEntry.getJavaDocText());
            apiParameters.add(enumEntry.getName(), "", elementsMapsAndSearchText.docElementsMaps, elementsMapsAndSearchText.searchText);
        });
        Map props = apiParameters.toMap();
        this.features.updateProps(props);
        props.putAll(this.pluginParams.getOpts().toMap());
        List docElements = PluginResult.docElement((String)"ApiParameters", (Map)props).getDocElements();
        return new JavaIncludeResult(docElements, this.extractText(javaCode.getEnumEntries()));
    }

    private boolean includeEnum(EnumEntry enumEntry) {
        boolean excludeDeprecated = (Boolean)this.pluginParams.getOpts().get("excludeDeprecated", (Object)false);
        return !excludeDeprecated || !enumEntry.isDeprecated();
    }

    private String extractText(List<EnumEntry> enums) {
        return enums.stream().map(e -> e.getName() + " " + e.getJavaDocText()).collect(Collectors.joining(" "));
    }

    private String determineAnchorPrefix() {
        if (this.entry != null) {
            return this.entry;
        }
        return this.fullPath.getFileName().toString();
    }
}

