/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.jupyter;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.jupyter.JupyterCell;
import org.testingisdocumenting.znai.jupyter.JupyterNotebook;
import org.testingisdocumenting.znai.jupyter.JupyterOutput;
import org.testingisdocumenting.znai.jupyter.JupyterParser;

public class JupyterParserVer4
implements JupyterParser {
    @Override
    public JupyterNotebook parse(Map<String, ?> json) {
        List cells = (List)json.get("cells");
        return new JupyterNotebook(this.parseLang(json), cells.stream().map(this::parseCell).collect(Collectors.toList()));
    }

    private JupyterCell parseCell(Object o) {
        String type;
        Map cellContent = (Map)o;
        switch (type = cellContent.get("cell_type").toString()) {
            case "code": {
                return this.parseCodeCell(cellContent);
            }
            case "markdown": {
                return this.parseMarkdownCell(cellContent);
            }
        }
        return new JupyterCell("unknown", "", Collections.emptyList());
    }

    private JupyterCell parseMarkdownCell(Map<String, ?> cellContent) {
        return new JupyterCell("markdown", this.joinLines(cellContent.get("source")), Collections.emptyList());
    }

    private JupyterCell parseCodeCell(Map<String, ?> cellContent) {
        String input = this.joinLines(cellContent.get("source"));
        List outputsContent = (List)cellContent.get("outputs");
        List<JupyterOutput> outputs = outputsContent.stream().map(this::parseOutput).collect(Collectors.toList());
        return new JupyterCell("code", input, outputs);
    }

    private JupyterOutput parseOutput(Map<String, ?> outputContent) {
        String type;
        switch (type = outputContent.get("output_type").toString()) {
            case "stream": {
                return new JupyterOutput("text", this.joinLines(outputContent.get("text")));
            }
        }
        return this.parseOutputData((Map)outputContent.get("data"));
    }

    private JupyterOutput parseOutputData(Map<String, ?> data) {
        Object html = data.get("text/html");
        if (html != null) {
            return new JupyterOutput("html", this.joinLines(html));
        }
        Object svg = data.get("image/svg+xml");
        if (svg != null) {
            return new JupyterOutput("svg", this.joinLines(svg));
        }
        Object img = data.get("image/png");
        if (img != null) {
            return new JupyterOutput("img", img.toString());
        }
        Object text = data.get("text/plain");
        return new JupyterOutput("text", this.joinLines(text));
    }

    private String joinLines(Object listOfLines) {
        List lines = (List)listOfLines;
        return String.join((CharSequence)"", lines);
    }

    private String parseLang(Map<String, ?> json) {
        Map metadata = (Map)json.get("metadata");
        Map kernelspec = (Map)metadata.get("kernelspec");
        return kernelspec.get("language").toString();
    }
}

