/*
 * Decompiled with CFR 0.152.
 */
package smetana.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import smetana.core.Bucket;
import smetana.core.CType;
import smetana.core.JUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructureDefinition {
    private static final Map<Class, StructureDefinition> all = new HashMap<Class, StructureDefinition>();
    private final Class cl;
    private Map<String, Bucket> buckets;

    public static StructureDefinition from(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        StructureDefinition structureDefinition = all.get(clazz);
        if (structureDefinition == null) {
            structureDefinition = new StructureDefinition(clazz);
            all.put(clazz, structureDefinition);
        }
        return structureDefinition;
    }

    private StructureDefinition(Class clazz) {
        this.cl = clazz;
    }

    public String toString() {
        return (this.cl == null ? "NO_CLASS" : this.cl.getName()) + " " + this.buckets;
    }

    private Map<String, Bucket> buckets() {
        if (this.buckets == null) {
            List<String> list = CType.getDefinition(this.cl);
            JUtils.LOG("StructureDefinition::run for " + this.cl);
            JUtils.LOG("def=" + list);
            JUtils.LOG("first=" + list.get(0));
            this.buckets = new LinkedHashMap<String, Bucket>();
            if (list.get(0).equals("typedef enum")) {
                String string = list.get(list.size() - 1);
                if (!string.matches("\\w+")) {
                    throw new UnsupportedOperationException();
                }
                this.buckets.put(string, Bucket.buildEnum(string, list));
                return this.buckets;
            }
            if (!(list.get(0).equals("typedef struct gvplugin_active_textlayout_s") || list.get(0).equals("typedef struct color_s") || list.get(0).equals("typedef struct") || list.get(0).equals("typedef struct pointf_s") || list.get(0).equals("typedef struct gvplugin_active_layout_s") || list.get(0).equals("typedef struct GVCOMMON_s") || list.get(0).equals("struct " + this.cl.getSimpleName()) || list.get(0).equals("typedef struct " + this.cl.getSimpleName()) || list.get(0).equals("typedef struct " + this.cl.getSimpleName().replaceFirst("_t", "_s")) || list.get(0).equals("typedef union " + this.cl.getSimpleName()))) {
                throw new IllegalStateException("<struct " + this.cl.getSimpleName() + "> VERSUS <" + list.get(0) + ">");
            }
            if (!list.get(1).equals("{")) {
                throw new IllegalStateException();
            }
            int n = list.size() - 1;
            if (list.get(list.size() - 2).equals("}") && list.get(list.size() - 1).equals(this.cl.getSimpleName())) {
                --n;
            }
            if (!list.get(n).equals("}")) {
                throw new IllegalStateException();
            }
            Iterator<String> iterator = list.subList(2, n).iterator();
            while (iterator.hasNext()) {
                this.buckets.putAll(Bucket.buildSome(iterator));
            }
        }
        return this.buckets;
    }

    public Set<String> getFields() {
        return this.buckets().keySet();
    }

    public Collection<Bucket> getBuckets() {
        return this.buckets().values();
    }

    public Map<String, Bucket> getBucketsMap() {
        return this.buckets();
    }

    public Bucket getBucket(String string) {
        Bucket bucket = this.buckets().get(string);
        if (bucket == null) {
            throw new IllegalArgumentException(string);
        }
        return bucket;
    }

    public Class getTheClass() {
        return this.cl;
    }

    public boolean containsFieldName(String string) {
        return this.buckets().keySet().contains(string);
    }
}

