/*
 * Decompiled with CFR 0.152.
 */
package smetana.core.amiga;

import smetana.core.Bucket;
import smetana.core.CType;
import smetana.core.JUtils;
import smetana.core.__array_of_double__;
import smetana.core.__array_of_integer_impl__;
import smetana.core.__array_of_ptr_impl__;
import smetana.core.__array_of_struct_impl__;
import smetana.core.amiga.Area;
import smetana.core.amiga.AreaDouble;
import smetana.core.amiga.AreaInt;
import smetana.core.amiga.StarStruct;

public class BucketToAreaFactory {
    public static Area createArea(Bucket bucket, StarStruct starStruct) {
        if (bucket.ctype.getArrayLength() != 0) {
            return BucketToAreaFactory.createAreaArray(bucket, bucket.ctype.getArrayLength());
        }
        if (bucket.ctype.functionPointer()) {
            return null;
        }
        if (bucket.ctype.isIntStar()) {
            return null;
        }
        if (bucket.ctype.isDoubleStar()) {
            return null;
        }
        if (bucket.ctype.isVoidStar()) {
            return null;
        }
        if (bucket.ctype.containsStar()) {
            String string = bucket.ctype.getType();
            if (string.matches("\\w+\\*")) {
                Class clazz = CType.getClassFrom(string.substring(0, string.length() - 1));
                JUtils.LOG("theClass=" + clazz);
                return null;
            }
            throw new UnsupportedOperationException(bucket.toString());
        }
        if (bucket.ctype.isEnum()) {
            return new AreaInt();
        }
        if (bucket.ctype.isPrimitive()) {
            if (bucket.ctype.isInteger()) {
                return new AreaInt();
            }
            if (bucket.ctype.isChar()) {
                return new AreaInt();
            }
            if (bucket.ctype.isShort()) {
                return new AreaInt();
            }
            if (bucket.ctype.isLong()) {
                return new AreaInt();
            }
            if (bucket.ctype.isBoolean()) {
                return new AreaInt();
            }
            if (bucket.ctype.isDoubleOrFloat()) {
                return new AreaDouble();
            }
            throw new UnsupportedOperationException();
        }
        if (bucket.inlineStruct()) {
            Class clazz = bucket.ctype.getTypeClass();
            return JUtils.create(clazz, starStruct);
        }
        if (bucket.ctype.isArrayOfCString()) {
            return null;
        }
        if (bucket.ctype.isCString()) {
            return null;
        }
        Class clazz = bucket.ctype.getTypeClass();
        if (clazz != null) {
            return null;
        }
        JUtils.LOG("BucketToAreaFactory:: theClass = " + clazz);
        JUtils.LOG("BucketToAreaFactory:: bucket=" + bucket);
        JUtils.LOG("BucketToAreaFactory:: bucket.ctype=" + bucket.ctype);
        throw new UnsupportedOperationException();
    }

    private static Area createAreaArray(Bucket bucket, int n) {
        JUtils.LOG("BucketToAreaFactory:createAreaArray: bucket=" + bucket);
        JUtils.LOG("BucketToAreaFactory:createAreaArray: arrayLength=" + n);
        JUtils.LOG("BucketToAreaFactory:createAreaArray: type=" + bucket.ctype);
        if (bucket.ctype.getType().matches("char \\w+\\[\\d+\\]")) {
            return __array_of_integer_impl__.mallocInteger(n);
        }
        if (bucket.ctype.getType().matches("int \\w+\\[\\d+\\]")) {
            return __array_of_integer_impl__.mallocInteger(n);
        }
        if (bucket.ctype.getType().matches("double \\w+\\[\\d+\\]")) {
            return __array_of_double__.mallocDouble(n);
        }
        if (bucket.ctype.getType().matches("\\w+ \\*\\w+\\[\\d+\\]")) {
            String string = bucket.ctype.getType().split(" ")[0];
            JUtils.LOG("element=" + string);
            Class clazz = CType.getClassFrom(string);
            JUtils.LOG("theClass=" + clazz);
            return __array_of_ptr_impl__.malloc_empty(n);
        }
        if (bucket.ctype.getType().matches("\\w+ \\w+\\[\\d+\\]")) {
            String string = bucket.ctype.getType().split(" ")[0];
            JUtils.LOG("element=" + string);
            Class clazz = CType.getClassFrom(string);
            JUtils.LOG("theClass=" + clazz);
            return __array_of_struct_impl__.malloc(clazz, n);
        }
        throw new UnsupportedOperationException();
    }
}

