/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.freemarker.core;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import znaishaded.freemarker.core.JavaTemplateDateFormat;
import znaishaded.freemarker.core.TemplateDateFormat;
import znaishaded.freemarker.core.TemplateDateFormatFactory;
import znaishaded.freemarker.core.UnknownDateTypeFormattingUnsupportedException;
import znaishaded.freemarker.template.TemplateModelException;

class JavaTemplateDateFormatFactory
extends TemplateDateFormatFactory {
    private static final Map JAVA_DATE_FORMATS = new HashMap();
    private final Locale locale;
    private Map[] formatCache;

    public JavaTemplateDateFormatFactory(TimeZone timeZone, Locale locale) {
        super(timeZone);
        this.locale = locale;
    }

    public boolean isLocaleBound() {
        return true;
    }

    public TemplateDateFormat get(int dateType, boolean zonelessInput, String formatDescriptor) throws ParseException, TemplateModelException, UnknownDateTypeFormattingUnsupportedException {
        TemplateDateFormat format;
        HashMap<String, TemplateDateFormat> formatsForDateType;
        Map[] formatCache = this.formatCache;
        if (formatCache == null) {
            this.formatCache = formatCache = new Map[4];
        }
        if ((formatsForDateType = formatCache[dateType]) == null) {
            formatCache[dateType] = formatsForDateType = new HashMap<String, TemplateDateFormat>();
        }
        if ((format = (TemplateDateFormat)formatsForDateType.get(formatDescriptor)) == null) {
            format = new JavaTemplateDateFormat(this.getJavaDateFormat(dateType, formatDescriptor));
            formatsForDateType.put(formatDescriptor, format);
        }
        return format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DateFormat getJavaDateFormat(int dateType, String nameOrPattern) throws UnknownDateTypeFormattingUnsupportedException, ParseException {
        DateFormat jDateFormat;
        DateFormatKey cacheKey = new DateFormatKey(dateType, nameOrPattern, this.locale, this.getTimeZone());
        Map map = JAVA_DATE_FORMATS;
        synchronized (map) {
            jDateFormat = (DateFormat)JAVA_DATE_FORMATS.get(cacheKey);
            if (jDateFormat == null) {
                int tok1Style;
                StringTokenizer tok = new StringTokenizer(nameOrPattern, "_");
                int n = tok1Style = tok.hasMoreTokens() ? this.parseDateStyleToken(tok.nextToken()) : 2;
                if (tok1Style != -1) {
                    switch (dateType) {
                        case 0: {
                            throw new UnknownDateTypeFormattingUnsupportedException();
                        }
                        case 1: {
                            jDateFormat = DateFormat.getTimeInstance(tok1Style, cacheKey.locale);
                            break;
                        }
                        case 2: {
                            jDateFormat = DateFormat.getDateInstance(tok1Style, cacheKey.locale);
                            break;
                        }
                        case 3: {
                            int tok2Style;
                            int n2 = tok2Style = tok.hasMoreTokens() ? this.parseDateStyleToken(tok.nextToken()) : tok1Style;
                            if (tok2Style == -1) break;
                            jDateFormat = DateFormat.getDateTimeInstance(tok1Style, tok2Style, cacheKey.locale);
                            break;
                        }
                    }
                }
                if (jDateFormat == null) {
                    try {
                        jDateFormat = new SimpleDateFormat(nameOrPattern, cacheKey.locale);
                    }
                    catch (IllegalArgumentException e) {
                        String msg = e.getMessage();
                        throw new ParseException(msg != null ? msg : "Illegal SimpleDateFormat pattern", 0);
                    }
                }
                jDateFormat.setTimeZone(cacheKey.timeZone);
                JAVA_DATE_FORMATS.put(cacheKey, jDateFormat);
            }
        }
        return (DateFormat)jDateFormat.clone();
    }

    private int parseDateStyleToken(String token) {
        if ("short".equals(token)) {
            return 3;
        }
        if ("medium".equals(token)) {
            return 2;
        }
        if ("long".equals(token)) {
            return 1;
        }
        if ("full".equals(token)) {
            return 0;
        }
        return -1;
    }

    private static final class DateFormatKey {
        private final int dateType;
        private final String pattern;
        private final Locale locale;
        private final TimeZone timeZone;

        DateFormatKey(int dateType, String pattern, Locale locale, TimeZone timeZone) {
            this.dateType = dateType;
            this.pattern = pattern;
            this.locale = locale;
            this.timeZone = timeZone;
        }

        public boolean equals(Object o) {
            if (o instanceof DateFormatKey) {
                DateFormatKey fk = (DateFormatKey)o;
                return this.dateType == fk.dateType && fk.pattern.equals(this.pattern) && fk.locale.equals(this.locale) && fk.timeZone.equals(this.timeZone);
            }
            return false;
        }

        public int hashCode() {
            return this.dateType ^ this.pattern.hashCode() ^ this.locale.hashCode() ^ this.timeZone.hashCode();
        }
    }
}

