/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.freemarker.debug;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.rmi.RemoteException;
import java.rmi.server.RemoteObject;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.List;
import znaishaded.freemarker.debug.Breakpoint;
import znaishaded.freemarker.debug.Debugger;
import znaishaded.freemarker.debug.DebuggerListener;
import znaishaded.freemarker.debug.impl.RmiDebuggerListenerImpl;
import znaishaded.freemarker.template.utility.UndeclaredThrowableException;

public class DebuggerClient {
    private DebuggerClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Debugger getDebugger(InetAddress host, int port2, String password) throws IOException {
        LocalDebuggerProxy localDebuggerProxy;
        Socket s = new Socket(host, port2);
        try {
            ObjectOutputStream out = new ObjectOutputStream(s.getOutputStream());
            ObjectInputStream in = new ObjectInputStream(s.getInputStream());
            int protocolVersion = in.readInt();
            if (protocolVersion > 220) {
                throw new IOException("Incompatible protocol version " + protocolVersion + ". At most 220 was expected.");
            }
            byte[] challenge = (byte[])in.readObject();
            MessageDigest md = MessageDigest.getInstance("SHA");
            md.update(password.getBytes("UTF-8"));
            md.update(challenge);
            out.writeObject(md.digest());
            localDebuggerProxy = new LocalDebuggerProxy((Debugger)in.readObject());
        }
        catch (Throwable throwable) {
            try {
                s.close();
                throw throwable;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e);
            }
        }
        s.close();
        return localDebuggerProxy;
    }

    private static class LocalDebuggerProxy
    implements Debugger {
        private final Debugger remoteDebugger;

        LocalDebuggerProxy(Debugger remoteDebugger) {
            this.remoteDebugger = remoteDebugger;
        }

        public void addBreakpoint(Breakpoint breakpoint) throws RemoteException {
            this.remoteDebugger.addBreakpoint(breakpoint);
        }

        public Object addDebuggerListener(DebuggerListener listener) throws RemoteException {
            if (listener instanceof RemoteObject) {
                return this.remoteDebugger.addDebuggerListener(listener);
            }
            RmiDebuggerListenerImpl remotableListener = new RmiDebuggerListenerImpl(listener);
            return this.remoteDebugger.addDebuggerListener(remotableListener);
        }

        public List getBreakpoints() throws RemoteException {
            return this.remoteDebugger.getBreakpoints();
        }

        public List getBreakpoints(String templateName) throws RemoteException {
            return this.remoteDebugger.getBreakpoints(templateName);
        }

        public Collection getSuspendedEnvironments() throws RemoteException {
            return this.remoteDebugger.getSuspendedEnvironments();
        }

        public void removeBreakpoint(Breakpoint breakpoint) throws RemoteException {
            this.remoteDebugger.removeBreakpoint(breakpoint);
        }

        public void removeBreakpoints(String templateName) throws RemoteException {
            this.remoteDebugger.removeBreakpoints(templateName);
        }

        public void removeBreakpoints() throws RemoteException {
            this.remoteDebugger.removeBreakpoints();
        }

        public void removeDebuggerListener(Object id) throws RemoteException {
            this.remoteDebugger.removeDebuggerListener(id);
        }
    }
}

