/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.freemarker.ext.beans;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import znaishaded.freemarker.ext.beans.BeansWrapper;
import znaishaded.freemarker.ext.beans.ClassIntrospector;
import znaishaded.freemarker.ext.beans.MethodAppearanceFineTuner;
import znaishaded.freemarker.ext.beans.MethodSorter;
import znaishaded.freemarker.ext.beans.SingletonCustomizer;
import znaishaded.freemarker.template.Version;

final class ClassIntrospectorBuilder
implements Cloneable {
    private final boolean bugfixed;
    private static final Map INSTANCE_CACHE = new HashMap();
    private static final ReferenceQueue INSTANCE_CACHE_REF_QUEUE = new ReferenceQueue();
    private int exposureLevel = 1;
    private boolean exposeFields;
    private MethodAppearanceFineTuner methodAppearanceFineTuner;
    private MethodSorter methodSorter;

    ClassIntrospectorBuilder(ClassIntrospector ci) {
        this.bugfixed = ci.bugfixed;
        this.exposureLevel = ci.exposureLevel;
        this.exposeFields = ci.exposeFields;
        this.methodAppearanceFineTuner = ci.methodAppearanceFineTuner;
        this.methodSorter = ci.methodSorter;
    }

    ClassIntrospectorBuilder(Version incompatibleImprovements) {
        this.bugfixed = BeansWrapper.is2321Bugfixed(incompatibleImprovements);
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failed to clone ClassIntrospectorBuilder", e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bugfixed ? 1231 : 1237);
        result = 31 * result + (this.exposeFields ? 1231 : 1237);
        result = 31 * result + this.exposureLevel;
        result = 31 * result + System.identityHashCode(this.methodAppearanceFineTuner);
        result = 31 * result + System.identityHashCode(this.methodSorter);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassIntrospectorBuilder other = (ClassIntrospectorBuilder)obj;
        if (this.bugfixed != other.bugfixed) {
            return false;
        }
        if (this.exposeFields != other.exposeFields) {
            return false;
        }
        if (this.exposureLevel != other.exposureLevel) {
            return false;
        }
        if (this.methodAppearanceFineTuner != other.methodAppearanceFineTuner) {
            return false;
        }
        return this.methodSorter == other.methodSorter;
    }

    public int getExposureLevel() {
        return this.exposureLevel;
    }

    public void setExposureLevel(int exposureLevel) {
        if (exposureLevel < 0 || exposureLevel > 3) {
            throw new IllegalArgumentException("Illegal exposure level: " + exposureLevel);
        }
        this.exposureLevel = exposureLevel;
    }

    public boolean getExposeFields() {
        return this.exposeFields;
    }

    public void setExposeFields(boolean exposeFields) {
        this.exposeFields = exposeFields;
    }

    public MethodAppearanceFineTuner getMethodAppearanceFineTuner() {
        return this.methodAppearanceFineTuner;
    }

    public void setMethodAppearanceFineTuner(MethodAppearanceFineTuner methodAppearanceFineTuner) {
        this.methodAppearanceFineTuner = methodAppearanceFineTuner;
    }

    public MethodSorter getMethodSorter() {
        return this.methodSorter;
    }

    public void setMethodSorter(MethodSorter methodSorter) {
        this.methodSorter = methodSorter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeClearedReferencesFromInstanceCache() {
        Reference clearedRef;
        while ((clearedRef = INSTANCE_CACHE_REF_QUEUE.poll()) != null) {
            Map map = INSTANCE_CACHE;
            synchronized (map) {
                Iterator it = INSTANCE_CACHE.values().iterator();
                while (it.hasNext()) {
                    if (it.next() != clearedRef) continue;
                    it.remove();
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearInstanceCache() {
        Map map = INSTANCE_CACHE;
        synchronized (map) {
            INSTANCE_CACHE.clear();
        }
    }

    static Map getInstanceCache() {
        return INSTANCE_CACHE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClassIntrospector build() {
        if ((this.methodAppearanceFineTuner == null || this.methodAppearanceFineTuner instanceof SingletonCustomizer) && (this.methodSorter == null || this.methodSorter instanceof SingletonCustomizer)) {
            ClassIntrospector instance;
            Map map = INSTANCE_CACHE;
            synchronized (map) {
                Reference instanceRef = (Reference)INSTANCE_CACHE.get(this);
                ClassIntrospector classIntrospector = instance = instanceRef != null ? (ClassIntrospector)instanceRef.get() : null;
                if (instance == null) {
                    ClassIntrospectorBuilder thisClone = (ClassIntrospectorBuilder)this.clone();
                    instance = new ClassIntrospector(thisClone, new Object(), true, true);
                    INSTANCE_CACHE.put(thisClone, new WeakReference<ClassIntrospector>(instance, INSTANCE_CACHE_REF_QUEUE));
                }
            }
            ClassIntrospectorBuilder.removeClearedReferencesFromInstanceCache();
            return instance;
        }
        return new ClassIntrospector(this, new Object(), true, false);
    }

    public boolean isBugfixed() {
        return this.bugfixed;
    }
}

