/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.freemarker.template;

import java.io.Serializable;
import java.util.Iterator;
import znaishaded.freemarker.ext.util.WrapperTemplateModel;
import znaishaded.freemarker.template.AdapterTemplateModel;
import znaishaded.freemarker.template.ObjectWrapper;
import znaishaded.freemarker.template.TemplateCollectionModel;
import znaishaded.freemarker.template.TemplateModel;
import znaishaded.freemarker.template.TemplateModelException;
import znaishaded.freemarker.template.TemplateModelIterator;
import znaishaded.freemarker.template.WrappingTemplateModel;

public class DefaultIteratorAdapter
extends WrappingTemplateModel
implements TemplateCollectionModel,
AdapterTemplateModel,
WrapperTemplateModel,
Serializable {
    private final Iterator iterator;
    private boolean iteratorOwned;

    public static DefaultIteratorAdapter adapt(Iterator iterator, ObjectWrapper wrapper) {
        return new DefaultIteratorAdapter(iterator, wrapper);
    }

    private DefaultIteratorAdapter(Iterator iterator, ObjectWrapper wrapper) {
        super(wrapper);
        this.iterator = iterator;
    }

    public Object getWrappedObject() {
        return this.iterator;
    }

    public Object getAdaptedObject(Class hint) {
        return this.getWrappedObject();
    }

    public TemplateModelIterator iterator() throws TemplateModelException {
        return new SimpleTemplateModelIterator();
    }

    private class SimpleTemplateModelIterator
    implements TemplateModelIterator {
        private boolean iteratorOwnedByMe;

        private SimpleTemplateModelIterator() {
        }

        public TemplateModel next() throws TemplateModelException {
            if (!this.iteratorOwnedByMe) {
                this.takeIteratorOwnership();
            }
            if (!DefaultIteratorAdapter.this.iterator.hasNext()) {
                throw new TemplateModelException("The collection has no more items.");
            }
            Object value = DefaultIteratorAdapter.this.iterator.next();
            return value instanceof TemplateModel ? (TemplateModel)value : DefaultIteratorAdapter.this.wrap(value);
        }

        public boolean hasNext() throws TemplateModelException {
            if (!this.iteratorOwnedByMe) {
                this.takeIteratorOwnership();
            }
            return DefaultIteratorAdapter.this.iterator.hasNext();
        }

        private void takeIteratorOwnership() throws TemplateModelException {
            if (DefaultIteratorAdapter.this.iteratorOwned) {
                throw new TemplateModelException("This collection value wraps a java.util.Iterator, thus it can be listed only once.");
            }
            DefaultIteratorAdapter.this.iteratorOwned = true;
            this.iteratorOwnedByMe = true;
        }
    }
}

