/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.http.impl;

import znaishaded.io.netty.channel.Channel;
import znaishaded.io.netty.channel.ChannelHandlerContext;
import znaishaded.io.netty.handler.codec.http.HttpMethod;
import znaishaded.io.netty.handler.codec.http.HttpRequest;
import znaishaded.io.netty.handler.codec.http.HttpResponseStatus;
import znaishaded.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import znaishaded.io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import znaishaded.io.vertx.core.VertxException;
import znaishaded.io.vertx.core.http.HttpHeaders;
import znaishaded.io.vertx.core.http.HttpServerOptions;
import znaishaded.io.vertx.core.http.impl.Http1xServerConnection;
import znaishaded.io.vertx.core.http.impl.HttpHandlers;
import znaishaded.io.vertx.core.http.impl.HttpServerImpl;
import znaishaded.io.vertx.core.http.impl.VertxHttpHandler;
import znaishaded.io.vertx.core.impl.ContextImpl;
import znaishaded.io.vertx.core.logging.Logger;
import znaishaded.io.vertx.core.logging.LoggerFactory;
import znaishaded.io.vertx.core.net.impl.HandlerHolder;
import znaishaded.io.vertx.core.net.impl.SSLHelper;
import znaishaded.io.vertx.core.spi.metrics.HttpServerMetrics;

public class Http1xServerHandler
extends VertxHttpHandler<Http1xServerConnection> {
    private static final Logger log = LoggerFactory.getLogger(Http1xServerHandler.class);
    private final SSLHelper sslHelper;
    private final HttpServerOptions options;
    private final String serverOrigin;
    private final HttpServerMetrics metrics;
    private final HandlerHolder<HttpHandlers> holder;

    public Http1xServerHandler(SSLHelper sslHelper, HttpServerOptions options, String serverOrigin, HandlerHolder<HttpHandlers> holder, HttpServerMetrics metrics) {
        this.holder = holder;
        this.metrics = metrics;
        this.sslHelper = sslHelper;
        this.options = options;
        this.serverOrigin = serverOrigin;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        Http1xServerConnection conn = new Http1xServerConnection(this.holder.context.owner(), this.sslHelper, this.options, ctx, this.holder.context, this.serverOrigin, this.metrics);
        this.setConnection(conn);
        conn.requestHandlers((HttpHandlers)this.holder.handler);
        if (this.metrics != null) {
            this.holder.context.executeFromIO(() -> conn.metric(this.metrics.connected(conn.remoteAddress(), conn.remoteName())));
        }
    }

    @Override
    protected void handleMessage(Http1xServerConnection conn, ContextImpl context, ChannelHandlerContext chctx, Object msg) throws Exception {
        conn.handleMessage(msg);
    }

    WebSocketServerHandshaker createHandshaker(Http1xServerConnection conn, Channel ch, HttpRequest request) {
        String connectionHeader = request.headers().get(HttpHeaders.CONNECTION);
        if (connectionHeader == null || !connectionHeader.toLowerCase().contains("upgrade")) {
            HttpServerImpl.sendError("\"Connection\" must be \"Upgrade\".", HttpResponseStatus.BAD_REQUEST, ch);
            return null;
        }
        if (request.getMethod() != HttpMethod.GET) {
            HttpServerImpl.sendError(null, HttpResponseStatus.METHOD_NOT_ALLOWED, ch);
            return null;
        }
        try {
            WebSocketServerHandshakerFactory factory = new WebSocketServerHandshakerFactory(HttpServerImpl.getWebSocketLocation(ch.pipeline(), request), conn.options.getWebsocketSubProtocols(), false, conn.options.getMaxWebsocketFrameSize(), conn.options.isAcceptUnmaskedFrames());
            WebSocketServerHandshaker shake = factory.newHandshaker(request);
            if (shake == null) {
                log.error("Unrecognised websockets handshake");
                WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse(ch);
            }
            return shake;
        }
        catch (Exception e) {
            throw new VertxException(e);
        }
    }
}

