/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.http.impl;

import java.nio.charset.Charset;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.Vertx;
import znaishaded.io.vertx.core.buffer.Buffer;
import znaishaded.io.vertx.core.file.AsyncFile;
import znaishaded.io.vertx.core.file.OpenOptions;
import znaishaded.io.vertx.core.http.HttpServerFileUpload;
import znaishaded.io.vertx.core.http.HttpServerRequest;
import znaishaded.io.vertx.core.streams.Pump;
import znaishaded.io.vertx.core.streams.WriteStream;

class HttpServerFileUploadImpl
implements HttpServerFileUpload {
    private final HttpServerRequest req;
    private final Vertx vertx;
    private final String name;
    private final String filename;
    private final String contentType;
    private final String contentTransferEncoding;
    private final Charset charset;
    private Handler<Buffer> dataHandler;
    private Handler<Void> endHandler;
    private AsyncFile file;
    private Handler<Throwable> exceptionHandler;
    private long size;
    private boolean paused;
    private Buffer pauseBuff;
    private boolean complete;
    private boolean lazyCalculateSize;

    HttpServerFileUploadImpl(Vertx vertx, HttpServerRequest req, String name, String filename, String contentType, String contentTransferEncoding, Charset charset, long size) {
        this.vertx = vertx;
        this.req = req;
        this.name = name;
        this.filename = filename;
        this.contentType = contentType;
        this.contentTransferEncoding = contentTransferEncoding;
        this.charset = charset;
        this.size = size;
        if (size == 0L) {
            this.lazyCalculateSize = true;
        }
    }

    @Override
    public String filename() {
        return this.filename;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String contentType() {
        return this.contentType;
    }

    @Override
    public String contentTransferEncoding() {
        return this.contentTransferEncoding;
    }

    @Override
    public String charset() {
        return this.charset.toString();
    }

    @Override
    public synchronized long size() {
        return this.size;
    }

    @Override
    public synchronized HttpServerFileUpload handler(Handler<Buffer> handler) {
        this.dataHandler = handler;
        return this;
    }

    @Override
    public synchronized HttpServerFileUpload pause() {
        this.req.pause();
        this.paused = true;
        return this;
    }

    @Override
    public synchronized HttpServerFileUpload resume() {
        if (this.paused) {
            this.req.resume();
            this.paused = false;
            if (this.pauseBuff != null) {
                this.doReceiveData(this.pauseBuff);
                this.pauseBuff = null;
            }
            if (this.complete) {
                this.handleComplete();
            }
        }
        return this;
    }

    @Override
    public synchronized HttpServerFileUpload exceptionHandler(Handler<Throwable> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    @Override
    public synchronized HttpServerFileUpload endHandler(Handler<Void> handler) {
        this.endHandler = handler;
        return this;
    }

    @Override
    public HttpServerFileUpload streamToFileSystem(String filename) {
        this.pause();
        this.vertx.fileSystem().open(filename, new OpenOptions(), ar -> {
            if (ar.succeeded()) {
                this.file = (AsyncFile)ar.result();
                Pump p = Pump.pump(this, (WriteStream)ar.result());
                p.start();
                this.resume();
            } else {
                this.notifyExceptionHandler(ar.cause());
            }
        });
        return this;
    }

    @Override
    public synchronized boolean isSizeAvailable() {
        return !this.lazyCalculateSize;
    }

    synchronized void receiveData(Buffer data) {
        if (data.length() != 0) {
            if (this.lazyCalculateSize) {
                this.size += (long)data.length();
            }
            this.doReceiveData(data);
        }
    }

    synchronized void doReceiveData(Buffer data) {
        if (!this.paused) {
            if (this.dataHandler != null) {
                this.dataHandler.handle(data);
            }
        } else {
            if (this.pauseBuff == null) {
                this.pauseBuff = Buffer.buffer();
            }
            this.pauseBuff.appendBuffer(data);
        }
    }

    synchronized void complete() {
        if (this.paused) {
            this.complete = true;
        } else {
            this.handleComplete();
        }
    }

    private void handleComplete() {
        this.lazyCalculateSize = false;
        if (this.file == null) {
            this.notifyEndHandler();
        } else {
            this.file.close(ar -> {
                if (ar.failed()) {
                    this.notifyExceptionHandler(ar.cause());
                }
                this.notifyEndHandler();
            });
        }
    }

    private void notifyEndHandler() {
        if (this.endHandler != null) {
            this.endHandler.handle(null);
        }
    }

    private void notifyExceptionHandler(Throwable cause) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle(cause);
        }
    }
}

