/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.net.impl;

import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import znaishaded.io.netty.bootstrap.ServerBootstrap;
import znaishaded.io.netty.channel.Channel;
import znaishaded.io.netty.channel.ChannelHandler;
import znaishaded.io.netty.channel.ChannelHandlerContext;
import znaishaded.io.netty.channel.ChannelInitializer;
import znaishaded.io.netty.channel.ChannelPipeline;
import znaishaded.io.netty.channel.EventLoop;
import znaishaded.io.netty.channel.group.ChannelGroup;
import znaishaded.io.netty.channel.group.ChannelGroupFuture;
import znaishaded.io.netty.channel.group.DefaultChannelGroup;
import znaishaded.io.netty.handler.logging.LoggingHandler;
import znaishaded.io.netty.handler.ssl.SslHandler;
import znaishaded.io.netty.handler.stream.ChunkedWriteHandler;
import znaishaded.io.netty.handler.timeout.IdleStateHandler;
import znaishaded.io.netty.util.concurrent.GenericFutureListener;
import znaishaded.io.netty.util.concurrent.GlobalEventExecutor;
import znaishaded.io.vertx.core.AsyncResult;
import znaishaded.io.vertx.core.Closeable;
import znaishaded.io.vertx.core.Future;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.impl.ContextImpl;
import znaishaded.io.vertx.core.impl.VertxInternal;
import znaishaded.io.vertx.core.logging.Logger;
import znaishaded.io.vertx.core.logging.LoggerFactory;
import znaishaded.io.vertx.core.net.NetServer;
import znaishaded.io.vertx.core.net.NetServerOptions;
import znaishaded.io.vertx.core.net.NetSocket;
import znaishaded.io.vertx.core.net.SocketAddress;
import znaishaded.io.vertx.core.net.impl.AsyncResolveConnectHelper;
import znaishaded.io.vertx.core.net.impl.HandlerHolder;
import znaishaded.io.vertx.core.net.impl.HandlerManager;
import znaishaded.io.vertx.core.net.impl.NetSocketImpl;
import znaishaded.io.vertx.core.net.impl.SSLHelper;
import znaishaded.io.vertx.core.net.impl.ServerID;
import znaishaded.io.vertx.core.net.impl.SocketAddressImpl;
import znaishaded.io.vertx.core.net.impl.VertxEventLoopGroup;
import znaishaded.io.vertx.core.net.impl.VertxNetHandler;
import znaishaded.io.vertx.core.net.impl.VertxSniHandler;
import znaishaded.io.vertx.core.spi.metrics.Metrics;
import znaishaded.io.vertx.core.spi.metrics.MetricsProvider;
import znaishaded.io.vertx.core.spi.metrics.TCPMetrics;
import znaishaded.io.vertx.core.spi.metrics.VertxMetrics;
import znaishaded.io.vertx.core.streams.ReadStream;

public class NetServerImpl
implements Closeable,
MetricsProvider,
NetServer {
    private static final Logger log = LoggerFactory.getLogger(NetServerImpl.class);
    protected final VertxInternal vertx;
    protected final NetServerOptions options;
    protected final ContextImpl creatingContext;
    protected final SSLHelper sslHelper;
    protected final boolean logEnabled;
    private final Map<Channel, NetSocketImpl> socketMap = new ConcurrentHashMap<Channel, NetSocketImpl>();
    private final VertxEventLoopGroup availableWorkers = new VertxEventLoopGroup();
    private final HandlerManager<Handlers> handlerManager = new HandlerManager(this.availableWorkers);
    private final NetSocketStream connectStream = new NetSocketStream();
    private ChannelGroup serverChannelGroup;
    private boolean paused;
    private volatile boolean listening;
    private Handler<NetSocket> registeredHandler;
    private volatile ServerID id;
    private NetServerImpl actualServer;
    private AsyncResolveConnectHelper bindFuture;
    private volatile int actualPort;
    private ContextImpl listenContext;
    private TCPMetrics metrics;
    private Handler<NetSocket> handler;
    private Handler<Void> endHandler;
    private Handler<Throwable> exceptionHandler;

    public NetServerImpl(VertxInternal vertx, NetServerOptions options) {
        this.vertx = vertx;
        this.options = new NetServerOptions(options);
        this.sslHelper = new SSLHelper(options, options.getKeyCertOptions(), options.getTrustOptions());
        this.creatingContext = vertx.getContext();
        this.logEnabled = options.getLogActivity();
        if (this.creatingContext != null) {
            if (this.creatingContext.isMultiThreadedWorkerContext()) {
                throw new IllegalStateException("Cannot use NetServer in a multi-threaded worker verticle");
            }
            this.creatingContext.addCloseHook(this);
        }
    }

    protected synchronized void pauseAccepting() {
        this.paused = true;
    }

    protected synchronized void resumeAccepting() {
        this.paused = false;
    }

    protected synchronized boolean isPaused() {
        return this.paused;
    }

    protected boolean isListening() {
        return this.listening;
    }

    @Override
    public synchronized Handler<NetSocket> connectHandler() {
        return this.handler;
    }

    @Override
    public synchronized NetServer connectHandler(Handler<NetSocket> handler) {
        if (this.isListening()) {
            throw new IllegalStateException("Cannot set connectHandler when server is listening");
        }
        this.handler = handler;
        return this;
    }

    @Override
    public synchronized NetServer exceptionHandler(Handler<Throwable> handler) {
        if (this.isListening()) {
            throw new IllegalStateException("Cannot set exceptionHandler when server is listening");
        }
        this.exceptionHandler = handler;
        return this;
    }

    protected void initChannel(ChannelPipeline pipeline) {
        if (this.logEnabled) {
            pipeline.addLast("logging", (ChannelHandler)new LoggingHandler());
        }
        if (this.sslHelper.isSSL()) {
            pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
        }
        if (this.options.getIdleTimeout() > 0) {
            pipeline.addLast("idle", (ChannelHandler)new IdleStateHandler(0, 0, this.options.getIdleTimeout()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void listen(Handler<NetSocket> handler, SocketAddress socketAddress, Handler<AsyncResult<Void>> listenHandler) {
        if (handler == null) {
            throw new IllegalStateException("Set connect handler first");
        }
        if (this.listening) {
            throw new IllegalStateException("Listen already called");
        }
        this.listening = true;
        this.listenContext = this.vertx.getOrCreateContext();
        this.registeredHandler = handler;
        Map<ServerID, NetServerImpl> map = this.vertx.sharedNetServers();
        synchronized (map) {
            this.actualPort = socketAddress.port();
            String hostOrPath = socketAddress.host() != null ? socketAddress.host() : socketAddress.path();
            this.id = new ServerID(this.actualPort, hostOrPath);
            NetServerImpl shared = this.vertx.sharedNetServers().get(this.id);
            if (shared == null || this.actualPort == 0) {
                this.serverChannelGroup = new DefaultChannelGroup("vertx-acceptor-channels", GlobalEventExecutor.INSTANCE);
                ServerBootstrap bootstrap = new ServerBootstrap();
                bootstrap.group(this.availableWorkers);
                this.sslHelper.validate(this.vertx);
                bootstrap.childHandler(new ChannelInitializer<Channel>(){

                    @Override
                    protected void initChannel(Channel ch) throws Exception {
                        if (NetServerImpl.this.isPaused()) {
                            ch.close();
                            return;
                        }
                        HandlerHolder handler = NetServerImpl.this.handlerManager.chooseHandler(ch.eventLoop());
                        if (handler != null) {
                            if (NetServerImpl.this.sslHelper.isSSL()) {
                                znaishaded.io.netty.util.concurrent.Future<Channel> handshakeFuture;
                                if (NetServerImpl.this.options.isSni()) {
                                    VertxSniHandler sniHandler = new VertxSniHandler(NetServerImpl.this.sslHelper, NetServerImpl.this.vertx);
                                    handshakeFuture = sniHandler.handshakeFuture();
                                    ch.pipeline().addFirst("ssl", (ChannelHandler)sniHandler);
                                } else {
                                    SslHandler sslHandler = new SslHandler(NetServerImpl.this.sslHelper.createEngine(NetServerImpl.this.vertx));
                                    handshakeFuture = sslHandler.handshakeFuture();
                                    ch.pipeline().addFirst("ssl", (ChannelHandler)sslHandler);
                                }
                                handshakeFuture.addListener(future -> {
                                    if (future.isSuccess()) {
                                        NetServerImpl.this.connected(handler, ch);
                                    } else {
                                        Handler<Throwable> exceptionHandler = ((Handlers)handler.handler).exceptionHandler;
                                        if (exceptionHandler != null) {
                                            handler.context.executeFromIO(() -> exceptionHandler.handle(future.cause()));
                                        } else {
                                            log.error("Client from origin " + ch.remoteAddress() + " failed to connect over ssl: " + future.cause());
                                        }
                                    }
                                });
                            } else {
                                NetServerImpl.this.connected(handler, ch);
                            }
                        }
                    }
                });
                this.applyConnectionOptions(bootstrap);
                this.handlerManager.addHandler(new Handlers(handler, this.exceptionHandler), this.listenContext);
                try {
                    this.bindFuture = AsyncResolveConnectHelper.doBind(this.vertx, socketAddress, bootstrap);
                    this.bindFuture.addListener(res -> {
                        if (res.succeeded()) {
                            Channel ch = (Channel)res.result();
                            log.trace("Net server listening on " + hostOrPath + ":" + ch.localAddress());
                            if (this.actualPort != -1) {
                                this.actualPort = ((InetSocketAddress)ch.localAddress()).getPort();
                            }
                            this.id = new ServerID(this.actualPort, this.id.host);
                            this.serverChannelGroup.add(ch);
                            this.vertx.sharedNetServers().put(this.id, this);
                            VertxMetrics metrics = this.vertx.metricsSPI();
                            if (metrics != null) {
                                this.metrics = metrics.createMetrics(new SocketAddressImpl(this.id.port, this.id.host), this.options);
                            }
                        } else {
                            this.vertx.sharedNetServers().remove(this.id);
                        }
                    });
                }
                catch (Throwable t) {
                    if (listenHandler != null) {
                        this.vertx.runOnContext(v -> listenHandler.handle(Future.failedFuture(t)));
                    } else {
                        log.error(t);
                    }
                    this.listening = false;
                    return;
                }
                if (this.actualPort != 0) {
                    this.vertx.sharedNetServers().put(this.id, this);
                }
                this.actualServer = this;
            } else {
                this.actualServer = shared;
                this.actualPort = shared.actualPort();
                VertxMetrics metrics = this.vertx.metricsSPI();
                this.metrics = metrics != null ? metrics.createMetrics(new SocketAddressImpl(this.id.port, this.id.host), this.options) : null;
                this.actualServer.handlerManager.addHandler(new Handlers(handler, this.exceptionHandler), this.listenContext);
            }
            this.actualServer.bindFuture.addListener(res -> {
                if (listenHandler != null) {
                    Future ares;
                    if (res.succeeded()) {
                        ares = Future.succeededFuture();
                    } else {
                        this.listening = false;
                        ares = Future.failedFuture(res.cause());
                    }
                    this.listenContext.runOnContext(v -> listenHandler.handle(ares));
                } else if (res.failed()) {
                    log.error((Object)"Failed to listen", res.cause());
                    this.listening = false;
                }
            });
        }
    }

    @Override
    public synchronized void close() {
        this.close(null);
    }

    @Override
    public NetServer listen(int port2, String host) {
        return this.listen(port2, host, null);
    }

    @Override
    public NetServer listen(int port2) {
        return this.listen(port2, "0.0.0.0", null);
    }

    @Override
    public NetServer listen(int port2, Handler<AsyncResult<NetServer>> listenHandler) {
        return this.listen(port2, "0.0.0.0", listenHandler);
    }

    @Override
    public NetServer listen(SocketAddress localAddress) {
        return this.listen(localAddress, null);
    }

    @Override
    public synchronized NetServer listen(SocketAddress localAddress, Handler<AsyncResult<NetServer>> listenHandler) {
        this.listen(this.handler, localAddress, (AsyncResult<Void> ar) -> {
            if (listenHandler != null) {
                listenHandler.handle(ar.map(this));
            }
        });
        return this;
    }

    @Override
    public NetServer listen() {
        this.listen((Handler<AsyncResult<NetServer>>)null);
        return this;
    }

    @Override
    public NetServer listen(int port2, String host, Handler<AsyncResult<NetServer>> listenHandler) {
        return this.listen(SocketAddress.inetSocketAddress(port2, host), listenHandler);
    }

    @Override
    public synchronized NetServer listen(Handler<AsyncResult<NetServer>> listenHandler) {
        return this.listen(this.options.getPort(), this.options.getHost(), listenHandler);
    }

    @Override
    public ReadStream<NetSocket> connectStream() {
        return this.connectStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close(Handler<AsyncResult<Void>> completionHandler) {
        Handler<AsyncResult<Void>> done;
        if (this.creatingContext != null) {
            this.creatingContext.removeCloseHook(this);
        }
        if (this.endHandler != null) {
            Handler<Void> handler = this.endHandler;
            this.endHandler = null;
            done = event -> {
                if (event.succeeded()) {
                    handler.handle((Void)event.result());
                }
                if (completionHandler != null) {
                    completionHandler.handle((AsyncResult<Void>)event);
                }
            };
        } else {
            done = completionHandler;
        }
        ContextImpl context = this.vertx.getOrCreateContext();
        if (!this.listening) {
            if (done != null) {
                this.executeCloseDone(context, done, null);
            }
            return;
        }
        this.listening = false;
        Map<ServerID, NetServerImpl> map = this.vertx.sharedNetServers();
        synchronized (map) {
            if (this.actualServer != null) {
                this.actualServer.handlerManager.removeHandler(new Handlers(this.registeredHandler, this.exceptionHandler), this.listenContext);
                if (this.actualServer.handlerManager.hasHandlers()) {
                    if (done != null) {
                        this.executeCloseDone(context, done, null);
                    }
                } else {
                    this.actualServer.actualClose(context, done);
                }
            } else {
                context.runOnContext(v -> done.handle(Future.succeededFuture()));
            }
        }
    }

    @Override
    public synchronized int actualPort() {
        return this.actualPort;
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.metrics != null;
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }

    private void actualClose(ContextImpl closeContext, Handler<AsyncResult<Void>> done) {
        if (this.id != null) {
            this.vertx.sharedNetServers().remove(this.id);
        }
        ContextImpl currCon = this.vertx.getContext();
        for (NetSocketImpl sock : this.socketMap.values()) {
            sock.close();
        }
        if (this.vertx.getContext() != currCon) {
            throw new IllegalStateException("Context was changed");
        }
        ChannelGroupFuture fut = this.serverChannelGroup.close();
        fut.addListener((GenericFutureListener<? extends znaishaded.io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<znaishaded.io.netty.util.concurrent.Future>)cg -> {
            if (this.metrics != null) {
                this.metrics.close();
            }
            this.executeCloseDone(closeContext, done, fut.cause());
        }));
    }

    private void connected(HandlerHolder<Handlers> handler, Channel ch) {
        EventLoop worker = ch.eventLoop();
        ContextImpl.setContext(handler.context);
        this.initChannel(ch.pipeline());
        VertxNetHandler nh = new VertxNetHandler(ctx -> new NetSocketImpl(this.vertx, (ChannelHandlerContext)ctx, handler.context, this.sslHelper, this.metrics)){

            @Override
            protected void handleMessage(NetSocketImpl connection, ContextImpl context, ChannelHandlerContext chctx, Object msg) throws Exception {
                connection.handleMessageReceived(msg);
            }
        };
        nh.addHandler(conn -> this.socketMap.put(ch, (NetSocketImpl)conn));
        nh.removeHandler(conn -> this.socketMap.remove(ch));
        ch.pipeline().addLast("handler", (ChannelHandler)nh);
        NetSocketImpl sock = (NetSocketImpl)nh.getConnection();
        handler.context.executeFromIO(() -> {
            if (this.metrics != null) {
                sock.metric(this.metrics.connected(sock.remoteAddress(), sock.remoteName()));
            }
            ((Handlers)handler.handler).connectionHandler.handle(sock);
        });
    }

    private void executeCloseDone(ContextImpl closeContext, Handler<AsyncResult<Void>> done, Exception e) {
        if (done != null) {
            Future fut = e == null ? Future.succeededFuture() : Future.failedFuture(e);
            closeContext.runOnContext(v -> done.handle(fut));
        }
    }

    protected void applyConnectionOptions(ServerBootstrap bootstrap) {
        this.vertx.transport().configure(this.options, bootstrap);
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    static class Handlers {
        final Handler<NetSocket> connectionHandler;
        final Handler<Throwable> exceptionHandler;

        public Handlers(Handler<NetSocket> connectionHandler, Handler<Throwable> exceptionHandler) {
            this.connectionHandler = connectionHandler;
            this.exceptionHandler = exceptionHandler;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Handlers that = (Handlers)o;
            if (!Objects.equals(this.connectionHandler, that.connectionHandler)) {
                return false;
            }
            return Objects.equals(this.exceptionHandler, that.exceptionHandler);
        }

        public int hashCode() {
            int result = 0;
            if (this.connectionHandler != null) {
                result = 31 * result + this.connectionHandler.hashCode();
            }
            if (this.exceptionHandler != null) {
                result = 31 * result + this.exceptionHandler.hashCode();
            }
            return result;
        }
    }

    private class NetSocketStream
    implements ReadStream<NetSocket> {
        private NetSocketStream() {
        }

        public NetSocketStream handler(Handler<NetSocket> handler) {
            NetServerImpl.this.connectHandler(handler);
            return this;
        }

        public NetSocketStream pause() {
            NetServerImpl.this.pauseAccepting();
            return this;
        }

        public NetSocketStream resume() {
            NetServerImpl.this.resumeAccepting();
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NetSocketStream endHandler(Handler<Void> handler) {
            NetServerImpl netServerImpl = NetServerImpl.this;
            synchronized (netServerImpl) {
                NetServerImpl.this.endHandler = handler;
                return this;
            }
        }

        @Override
        public NetSocketStream exceptionHandler(Handler<Throwable> handler) {
            return this;
        }
    }
}

