/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.net.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.UUID;
import znaishaded.io.netty.buffer.ByteBuf;
import znaishaded.io.netty.buffer.ByteBufAllocator;
import znaishaded.io.netty.buffer.Unpooled;
import znaishaded.io.netty.channel.Channel;
import znaishaded.io.netty.channel.ChannelFuture;
import znaishaded.io.netty.channel.ChannelFutureListener;
import znaishaded.io.netty.channel.ChannelHandler;
import znaishaded.io.netty.channel.ChannelHandlerContext;
import znaishaded.io.netty.channel.ChannelOutboundHandler;
import znaishaded.io.netty.channel.ChannelPromise;
import znaishaded.io.netty.handler.ssl.SslHandler;
import znaishaded.io.netty.util.CharsetUtil;
import znaishaded.io.netty.util.concurrent.GenericFutureListener;
import znaishaded.io.vertx.core.AsyncResult;
import znaishaded.io.vertx.core.Future;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.buffer.Buffer;
import znaishaded.io.vertx.core.eventbus.Message;
import znaishaded.io.vertx.core.eventbus.MessageConsumer;
import znaishaded.io.vertx.core.impl.ContextImpl;
import znaishaded.io.vertx.core.impl.NetSocketInternal;
import znaishaded.io.vertx.core.impl.VertxInternal;
import znaishaded.io.vertx.core.logging.Logger;
import znaishaded.io.vertx.core.logging.LoggerFactory;
import znaishaded.io.vertx.core.net.NetSocket;
import znaishaded.io.vertx.core.net.SocketAddress;
import znaishaded.io.vertx.core.net.impl.ConnectionBase;
import znaishaded.io.vertx.core.net.impl.SSLHelper;
import znaishaded.io.vertx.core.net.impl.VertxHandler;
import znaishaded.io.vertx.core.net.impl.VertxSniHandler;
import znaishaded.io.vertx.core.spi.metrics.TCPMetrics;

public class NetSocketImpl
extends ConnectionBase
implements NetSocketInternal {
    private static final Handler<Object> NULL_MSG_HANDLER = event -> {
        if (event instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)event;
            byteBuf.release();
        }
    };
    private static final Logger log = LoggerFactory.getLogger(NetSocketImpl.class);
    private final String writeHandlerID;
    private final MessageConsumer registration;
    private final SSLHelper helper;
    private final SocketAddress remoteAddress;
    private final TCPMetrics metrics;
    private Handler<Object> messageHandler = NULL_MSG_HANDLER;
    private Handler<Void> endHandler;
    private Handler<Void> drainHandler;
    private Buffer pendingData;
    private boolean paused = false;

    public NetSocketImpl(VertxInternal vertx, ChannelHandlerContext channel2, ContextImpl context, SSLHelper helper, TCPMetrics metrics) {
        this(vertx, channel2, null, context, helper, metrics);
    }

    public NetSocketImpl(VertxInternal vertx, ChannelHandlerContext channel2, SocketAddress remoteAddress, ContextImpl context, SSLHelper helper, TCPMetrics metrics) {
        super(vertx, channel2, context);
        this.helper = helper;
        this.writeHandlerID = UUID.randomUUID().toString();
        this.remoteAddress = remoteAddress;
        this.metrics = metrics;
        Handler<Message> writeHandler = msg -> this.write((Buffer)msg.body());
        this.registration = vertx.eventBus().localConsumer(this.writeHandlerID).handler(writeHandler);
    }

    @Override
    public ChannelHandlerContext channelHandlerContext() {
        return this.chctx;
    }

    @Override
    public TCPMetrics metrics() {
        return this.metrics;
    }

    @Override
    public String writeHandlerID() {
        return this.writeHandlerID;
    }

    @Override
    public NetSocketInternal writeMessage(Object message) {
        super.writeToChannel(message);
        return this;
    }

    @Override
    public NetSocketInternal writeMessage(Object message, final Handler<AsyncResult<Void>> handler) {
        ChannelPromise promise = this.chctx.newPromise();
        super.writeToChannel(message, promise);
        promise.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    handler.handle(Future.succeededFuture());
                } else {
                    handler.handle(Future.failedFuture(future.cause()));
                }
            }
        });
        return this;
    }

    @Override
    public NetSocket write(Buffer data) {
        ByteBuf buf = data.getByteBuf();
        this.write(buf);
        return this;
    }

    @Override
    public NetSocket write(String str) {
        this.write(Unpooled.copiedBuffer(str, CharsetUtil.UTF_8));
        return this;
    }

    @Override
    public NetSocket write(String str, String enc) {
        if (enc == null) {
            this.write(str);
        } else {
            this.write(Unpooled.copiedBuffer(str, Charset.forName(enc)));
        }
        return this;
    }

    @Override
    public synchronized NetSocket handler(Handler<Buffer> dataHandler) {
        if (dataHandler != null) {
            this.messageHandler(new DataMessageHandler(this.channelHandlerContext().alloc(), dataHandler));
        } else {
            this.messageHandler(null);
        }
        return this;
    }

    @Override
    public synchronized NetSocketInternal messageHandler(Handler<Object> handler) {
        this.messageHandler = handler != null ? handler : NULL_MSG_HANDLER;
        return this;
    }

    @Override
    public synchronized NetSocket pause() {
        if (!this.paused) {
            this.paused = true;
            this.doPause();
        }
        return this;
    }

    @Override
    public synchronized NetSocket resume() {
        if (this.paused) {
            this.paused = false;
            if (this.pendingData != null) {
                this.context.runOnContext(v -> this.handleMessageReceived(Unpooled.EMPTY_BUFFER));
            }
            this.doResume();
        }
        return this;
    }

    @Override
    public NetSocket setWriteQueueMaxSize(int maxSize) {
        this.doSetWriteQueueMaxSize(maxSize);
        return this;
    }

    @Override
    public boolean writeQueueFull() {
        return this.isNotWritable();
    }

    @Override
    public synchronized NetSocket endHandler(Handler<Void> endHandler) {
        this.endHandler = endHandler;
        return this;
    }

    @Override
    public synchronized NetSocket drainHandler(Handler<Void> drainHandler) {
        this.drainHandler = drainHandler;
        this.vertx.runOnContext(v -> this.callDrainHandler());
        return this;
    }

    @Override
    public NetSocket sendFile(String filename, long offset, long length) {
        return this.sendFile(filename, offset, length, null);
    }

    @Override
    public NetSocket sendFile(String filename, long offset, long length, Handler<AsyncResult<Void>> resultHandler) {
        File f = this.vertx.resolveFile(filename);
        if (f.isDirectory()) {
            throw new IllegalArgumentException("filename must point to a file and not to a directory");
        }
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(f, "r");
            ChannelFuture future = super.sendFile(raf, Math.min(offset, f.length()), Math.min(length, f.length() - offset));
            if (resultHandler != null) {
                future.addListener((GenericFutureListener<? extends znaishaded.io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<znaishaded.io.netty.util.concurrent.Future>)fut -> {
                    Future res = future.isSuccess() ? Future.succeededFuture() : Future.failedFuture(future.cause());
                    this.vertx.runOnContext(v -> resultHandler.handle(res));
                }));
            }
        }
        catch (IOException e) {
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (resultHandler != null) {
                this.vertx.runOnContext(v -> resultHandler.handle(Future.failedFuture(e)));
            }
            log.error((Object)"Failed to send file", e);
        }
        return this;
    }

    @Override
    public SocketAddress remoteAddress() {
        return super.remoteAddress();
    }

    @Override
    public SocketAddress localAddress() {
        return super.localAddress();
    }

    @Override
    public NetSocketImpl exceptionHandler(Handler<Throwable> handler) {
        return (NetSocketImpl)super.exceptionHandler(handler);
    }

    @Override
    public NetSocketImpl closeHandler(Handler<Void> handler) {
        return (NetSocketImpl)super.closeHandler(handler);
    }

    @Override
    public synchronized void close() {
        this.chctx.write(Unpooled.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
        this.chctx.flush();
    }

    @Override
    public NetSocket upgradeToSsl(Handler<Void> handler) {
        return this.upgradeToSsl(null, handler);
    }

    @Override
    public NetSocket upgradeToSsl(String serverName, Handler<Void> handler) {
        ChannelHandler sslHandler = (ChannelOutboundHandler)this.chctx.pipeline().get("ssl");
        if (sslHandler == null) {
            sslHandler = this.remoteAddress != null ? new SslHandler(this.helper.createEngine(this.vertx, this.remoteAddress, serverName)) : (this.helper.isSNI() ? new VertxSniHandler(this.helper, this.vertx) : new SslHandler(this.helper.createEngine(this.vertx)));
            this.chctx.pipeline().addFirst("ssl", sslHandler);
        }
        znaishaded.io.netty.util.concurrent.Future<Channel> handshakeFuture = sslHandler instanceof SslHandler ? ((SslHandler)sslHandler).handshakeFuture() : ((VertxSniHandler)sslHandler).handshakeFuture();
        handshakeFuture.addListener(future -> this.context.executeFromIO(() -> {
            if (future.isSuccess()) {
                handler.handle(null);
            } else {
                log.error(future.cause());
            }
        }));
        return this;
    }

    @Override
    protected synchronized void handleInterestedOpsChanged() {
        this.checkContext();
        this.callDrainHandler();
    }

    @Override
    public void end() {
        this.close();
    }

    @Override
    protected synchronized void handleClosed() {
        this.checkContext();
        if (this.endHandler != null) {
            this.endHandler.handle(null);
        }
        super.handleClosed();
        if (this.vertx.eventBus() != null) {
            this.registration.unregister();
        }
    }

    public synchronized void handleMessageReceived(Object msg) {
        this.checkContext();
        if (this.messageHandler != null) {
            this.messageHandler.handle(msg);
        }
    }

    private void write(ByteBuf buff) {
        this.reportBytesWritten(buff.readableBytes());
        super.writeToChannel(buff);
    }

    private synchronized void callDrainHandler() {
        if (this.drainHandler != null && !this.writeQueueFull()) {
            this.drainHandler.handle(null);
        }
    }

    private class DataMessageHandler
    implements Handler<Object> {
        private final ByteBufAllocator allocator;
        private final Handler<Buffer> dataHandler;

        public DataMessageHandler(ByteBufAllocator allocator, Handler<Buffer> dataHandler) {
            this.dataHandler = dataHandler;
            this.allocator = allocator;
        }

        @Override
        public void handle(Object event) {
            if (event instanceof ByteBuf) {
                ByteBuf byteBuf = (ByteBuf)event;
                byteBuf = VertxHandler.safeBuffer(byteBuf, this.allocator);
                Buffer data = Buffer.buffer(byteBuf);
                NetSocketImpl.this.reportBytesRead(data.length());
                if (NetSocketImpl.this.paused) {
                    if (NetSocketImpl.this.pendingData == null) {
                        NetSocketImpl.this.pendingData = data.copy();
                    } else {
                        NetSocketImpl.this.pendingData.appendBuffer(data);
                    }
                    return;
                }
                if (NetSocketImpl.this.pendingData != null) {
                    data = NetSocketImpl.this.pendingData.appendBuffer(data);
                    NetSocketImpl.this.pendingData = null;
                }
                this.dataHandler.handle(data);
            }
        }
    }
}

