/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.net.impl;

import javax.net.ssl.SSLEngine;
import znaishaded.io.netty.channel.Channel;
import znaishaded.io.netty.channel.ChannelHandler;
import znaishaded.io.netty.channel.ChannelHandlerContext;
import znaishaded.io.netty.handler.ssl.SniHandler;
import znaishaded.io.netty.handler.ssl.SslContext;
import znaishaded.io.netty.handler.ssl.SslHandler;
import znaishaded.io.netty.util.Attribute;
import znaishaded.io.netty.util.AttributeKey;
import znaishaded.io.netty.util.ReferenceCountUtil;
import znaishaded.io.netty.util.concurrent.DefaultPromise;
import znaishaded.io.netty.util.concurrent.EventExecutor;
import znaishaded.io.netty.util.concurrent.Future;
import znaishaded.io.netty.util.concurrent.Promise;
import znaishaded.io.vertx.core.impl.VertxInternal;
import znaishaded.io.vertx.core.net.impl.SSLHelper;

public class VertxSniHandler
extends SniHandler {
    public static AttributeKey<String> SERVER_NAME_ATTR = AttributeKey.valueOf("sniServerName");
    private final SSLHelper helper;
    private ChannelHandlerContext context;
    private final Promise<Channel> handshakeFuture;

    public VertxSniHandler(SSLHelper helper, VertxInternal vertx) {
        super((? super String input) -> helper.getContext(vertx, (String)input));
        this.helper = helper;
        this.handshakeFuture = new DefaultPromise<Channel>(){

            @Override
            protected EventExecutor executor() {
                ChannelHandlerContext ctx = VertxSniHandler.this.context;
                if (ctx == null) {
                    throw new IllegalStateException();
                }
                return ctx.executor();
            }
        };
    }

    public Future<Channel> handshakeFuture() {
        return this.handshakeFuture;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.context = ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void replaceHandler(ChannelHandlerContext ctx, String hostname, SslContext sslContext) throws Exception {
        SslHandler sslHandler = null;
        try {
            SSLEngine engine = this.helper.createEngine(sslContext);
            sslHandler = new SslHandler(engine);
            ctx.pipeline().replace(this, "ssl", (ChannelHandler)sslHandler);
            Future<Channel> fut = sslHandler.handshakeFuture();
            fut.addListener(future -> {
                if (future.isSuccess()) {
                    Attribute<String> val = ctx.channel().attr(SERVER_NAME_ATTR);
                    val.set(hostname);
                    this.handshakeFuture.setSuccess(ctx.channel());
                } else {
                    this.handshakeFuture.setFailure(future.cause());
                }
            });
            sslHandler = null;
        }
        finally {
            if (sslHandler != null) {
                ReferenceCountUtil.safeRelease(sslHandler.engine());
            }
        }
    }
}

