/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.ext.web.handler.impl;

import java.util.List;
import znaishaded.io.vertx.core.AsyncResult;
import znaishaded.io.vertx.core.Future;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.json.JsonArray;
import znaishaded.io.vertx.core.json.JsonObject;
import znaishaded.io.vertx.ext.auth.AuthProvider;
import znaishaded.io.vertx.ext.auth.jwt.JWTAuth;
import znaishaded.io.vertx.ext.web.RoutingContext;
import znaishaded.io.vertx.ext.web.handler.JWTAuthHandler;
import znaishaded.io.vertx.ext.web.handler.impl.AuthorizationAuthHandler;

public class JWTAuthHandlerImpl
extends AuthorizationAuthHandler
implements JWTAuthHandler {
    private final String skip;
    private final JsonObject options;

    public JWTAuthHandlerImpl(JWTAuth authProvider, String skip) {
        super((AuthProvider)authProvider, AuthorizationAuthHandler.Type.BEARER);
        this.skip = skip;
        this.options = new JsonObject();
    }

    @Override
    public JWTAuthHandler setAudience(List<String> audience) {
        this.options.put("audience", new JsonArray(audience));
        return this;
    }

    @Override
    public JWTAuthHandler setIssuer(String issuer) {
        this.options.put("issuer", issuer);
        return this;
    }

    @Override
    public JWTAuthHandler setIgnoreExpiration(boolean ignoreExpiration) {
        this.options.put("ignoreExpiration", ignoreExpiration);
        return this;
    }

    @Override
    public void parseCredentials(RoutingContext context, Handler<AsyncResult<JsonObject>> handler) {
        if (this.skip != null && context.normalisedPath().startsWith(this.skip)) {
            context.next();
            return;
        }
        this.parseAuthorization(context, false, parseAuthorization -> {
            if (parseAuthorization.failed()) {
                handler.handle(Future.failedFuture(parseAuthorization.cause()));
                return;
            }
            handler.handle(Future.succeededFuture(new JsonObject().put("jwt", (String)parseAuthorization.result()).put("options", this.options)));
        });
    }

    @Override
    protected String authenticateHeader(RoutingContext context) {
        return "Bearer";
    }
}

